/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Data.NumberPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public final class ESNumber
extends ESPrimitive {
    private double value;

    public ESNumber(double value) {
        this.value = value;
    }

    public int getTypeOf() {
        return 4;
    }

    public String getTypeofString() {
        return "number";
    }

    public boolean isNumberValue() {
        return true;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean booleanValue() {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    public String toString() {
        long intValue = (long)this.value;
        if ((double)intValue == this.value) {
            return Long.toString(intValue);
        }
        return Double.toString(this.value);
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        NumberPrototype theObject = null;
        ESObject np = evaluator.getNumberPrototype();
        theObject = new NumberPrototype(np, evaluator);
        theObject.value = this;
        return theObject;
    }

    public ESValue toESNumber() {
        return this;
    }

    public Object toJavaObject() {
        long longValue = (long)this.value;
        Number o = null;
        o = (double)longValue == this.value ? (Number)((long)((byte)longValue) == longValue ? (Number)new Byte((byte)longValue) : (Number)((long)((short)longValue) == longValue ? (Number)new Short((short)longValue) : (Number)((long)((int)longValue) == longValue ? (Number)new Integer((int)longValue) : (Number)new Long(longValue)))) : (Number)new Double(this.value);
        return o;
    }

    public String toDetailString() {
        return "ES:#'" + Double.toString(this.value) + "'";
    }
}

