/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ESArrayWrapper
extends ESObject {
    protected Object javaArray;

    public ESArrayWrapper(Object javaArray, Evaluator evaluator) {
        super(null, evaluator);
        this.javaArray = javaArray;
        if (!javaArray.getClass().isArray()) {
            throw new ProgrammingError("Array wrapper used on non array object");
        }
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Array Wrapper");
    }

    public String getESClassName() {
        return "Java Array";
    }

    public int getTypeOf() {
        return 6;
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (propertyName.equals("length")) {
            int length = (int)((ESPrimitive)propertyValue).doubleValue();
            if (length < 0) {
                throw new EcmaScriptException("Invalid length value: " + propertyValue);
            }
            throw new EcmaScriptException("length of Java Arrays is immutable");
        }
        int index = -1;
        try {
            index = Integer.parseInt(propertyName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index < 0) {
            throw new EcmaScriptException("Java Arrays accept only index properties");
        }
        this.putProperty(index, propertyValue);
    }

    public void putProperty(int index, ESValue propertyValue) throws EcmaScriptException {
        int l = Array.getLength(this.javaArray);
        if (index >= l || index < 0) {
            throw new EcmaScriptException("Index " + index + " outside of Java Arrays size of " + l);
        }
        Object obj = propertyValue.toJavaObject();
        try {
            Array.set(this.javaArray, index, obj);
        }
        catch (IllegalArgumentException e) {
            String type = "null";
            if (obj != null) {
                type = ESLoader.typeName(obj.getClass());
            }
            throw new EcmaScriptException("Cannot store a " + type + " in the java array " + ESLoader.typeName(this.javaArray.getClass()));
        }
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (propertyName.equals("length")) {
            return new ESNumber(Array.getLength(this.javaArray));
        }
        if (previousScope == null) {
            throw new EcmaScriptException("global variable '" + propertyName + "' does not have a value");
        }
        return previousScope.getValue(propertyName, hash);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("length")) {
            return new ESNumber(Array.getLength(this.javaArray));
        }
        int index = -1;
        try {
            index = Integer.parseInt(propertyName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index < 0) {
            throw new EcmaScriptException("Java Arrays accept only index properties");
        }
        return this.getProperty(index);
    }

    public ESValue getProperty(int index) throws EcmaScriptException {
        Object theElement = null;
        int l = Array.getLength(this.javaArray);
        if (index >= l || index < 0) {
            throw new EcmaScriptException("Java Array index " + index + " is out of range " + l);
        }
        theElement = Array.get(this.javaArray, index);
        return ESLoader.normalizeValue(theElement, this.evaluator);
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("length")) {
            return true;
        }
        int index = -1;
        try {
            index = Integer.parseInt(propertyName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index < 0) {
            return false;
        }
        return index >= 0 && index < Array.getLength(this.javaArray);
    }

    public Enumeration getProperties() {
        return new Enumeration(){
            int nextIndex = 0;
            int length;
            {
                this.length = Array.getLength(ESArrayWrapper.this.javaArray);
            }

            public boolean hasMoreElements() {
                while (this.nextIndex < this.length && Array.get(ESArrayWrapper.this.javaArray, this.nextIndex) == null) {
                    ++this.nextIndex;
                }
                return this.nextIndex < this.length;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    return new ESNumber(this.nextIndex++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration getAllProperties() {
        return new Enumeration(){
            String[] specialProperties;
            int specialEnumerator;
            Enumeration props;
            String currentKey;
            int currentHash;
            int nextIndex;
            int length;
            {
                this.specialProperties = ESArrayWrapper.this.getSpecialPropertyNames();
                this.specialEnumerator = 0;
                this.props = ESArrayWrapper.this.properties.keys();
                this.currentKey = null;
                this.currentHash = 0;
                this.nextIndex = 0;
                this.length = Array.getLength(ESArrayWrapper.this.javaArray);
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                if (this.nextIndex < this.length) {
                    while (this.nextIndex < this.length && Array.get(ESArrayWrapper.this.javaArray, this.nextIndex) == null) {
                        ++this.nextIndex;
                    }
                    if (this.nextIndex < this.length) {
                        this.currentKey = Integer.toString(this.nextIndex);
                        this.currentHash = this.currentKey.hashCode();
                        ++this.nextIndex;
                        return true;
                    }
                }
                if (this.specialEnumerator < this.specialProperties.length) {
                    this.currentKey = this.specialProperties[this.specialEnumerator];
                    this.currentHash = this.currentKey.hashCode();
                    ++this.specialEnumerator;
                    return true;
                }
                if (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{"length"};
        return ns;
    }

    public boolean isHiddenProperty(String propertyName, int hash) {
        return false;
    }

    public void putHiddenProperty(String propertyName, ESValue propertyValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        return !this.hasProperty(propertyName, hash);
    }

    public ESValue getDefaultValue(int hint) throws EcmaScriptException {
        if (hint == 5) {
            return new ESString(this.javaArray.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + hint);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        return this.javaArray == null ? "<?Array Wrapper to null?>" : "[object JavaArray]";
    }

    public Object toJavaObject() {
        return this.javaArray;
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + ":" + this.javaArray.toString() + "]";
    }
}

