/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.DatePrototype;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateObject
extends BuiltinFunctionObject {
    private DateObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "Date", 7);
    }

    public String toString() {
        return "<Date>";
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        return new ESString(new Date().toString());
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        DatePrototype theObject = null;
        ESObject dp = this.evaluator.getDatePrototype();
        theObject = new DatePrototype(dp, this.evaluator);
        int l = arguments.length;
        if (l == 2 || l == 0) {
            theObject.date = new Date();
        } else if (l == 1) {
            double d = arguments[0].doubleValue();
            theObject.date = Double.isNaN(d) ? null : new Date((long)d);
        } else {
            int year = arguments[0].toInt32();
            if (0 <= year && year <= 99) {
                year += 1900;
            }
            int month = arguments[1].toInt32();
            int day = arguments[2].toInt32();
            int hour = l > 3 ? arguments[3].toInt32() : 0;
            int minute = l > 4 ? arguments[4].toInt32() : 0;
            int second = l > 5 ? arguments[5].toInt32() : 0;
            int ms = l > 6 ? arguments[6].toInt32() : 0;
            GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
            if (ms != 0) {
                cal.set(14, ms);
            }
            theObject.date = cal.getTime();
        }
        return theObject;
    }

    public static DateObject makeDateObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        DatePrototype datePrototype = new DatePrototype(objectPrototype, evaluator);
        DateObject dateObject = new DateObject(functionPrototype, evaluator);
        try {
            dateObject.putHiddenProperty("prototype", datePrototype);
            dateObject.putHiddenProperty("length", new ESNumber(7.0));
            class DateObjectParse
            extends BuiltinFunctionObject {
                DateObjectParse(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (arguments.length <= 0) {
                        throw new EcmaScriptException("Missing argument");
                    }
                    String dateString = arguments[0].toString();
                    DateFormat df = DateFormat.getDateInstance();
                    ESNumber dateValue = null;
                    try {
                        Date date = df.parse(dateString);
                        dateValue = new ESNumber(date.getTime());
                    }
                    catch (ParseException e) {
                        dateValue = new ESNumber(Double.NaN);
                    }
                    return dateValue;
                }
            }
            dateObject.putHiddenProperty("parse", new DateObjectParse("parse", evaluator, functionPrototype));
            class DateObjectUTC
            extends BuiltinFunctionObject {
                DateObjectUTC(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 7);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    int l = arguments.length;
                    if (l <= 2) {
                        throw new EcmaScriptException("Missing argument");
                    }
                    int year = arguments[0].toInt32();
                    if (0 <= year && year <= 99) {
                        year += 1900;
                    }
                    int month = arguments[1].toInt32();
                    int day = arguments[2].toInt32();
                    int hour = l > 3 ? arguments[3].toInt32() : 0;
                    int minute = l > 4 ? arguments[4].toInt32() : 0;
                    int second = l > 5 ? arguments[5].toInt32() : 0;
                    int ms = l > 6 ? arguments[6].toInt32() : 0;
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.set(1, year);
                    cal.set(2, month);
                    cal.set(5, day);
                    cal.set(11, hour);
                    cal.set(12, minute);
                    cal.set(13, second);
                    cal.set(14, ms);
                    long timeinms = cal.getTime().getTime();
                    return new ESNumber(timeinms);
                }
            }
            dateObject.putHiddenProperty("UTC", new DateObjectUTC("UTC", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("constructor", dateObject);
            class DatePrototypeToString
            extends BuiltinFunctionObject {
                DatePrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.date == null ? new ESString("NaN") : new ESString(aDate.date.toString());
                }
            }
            datePrototype.putHiddenProperty("toString", new DatePrototypeToString("toString", evaluator, functionPrototype));
            class DatePrototypeToLocaleString
            extends BuiltinFunctionObject {
                DatePrototypeToLocaleString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    DateFormat df = DateFormat.getDateTimeInstance();
                    df.setTimeZone(TimeZone.getDefault());
                    return aDate.date == null ? new ESString("NaN") : new ESString(df.format(aDate.date));
                }
            }
            datePrototype.putHiddenProperty("toLocaleString", new DatePrototypeToLocaleString("toLocaleString", evaluator, functionPrototype));
            class DatePrototypeToGMTString
            extends BuiltinFunctionObject {
                DatePrototypeToGMTString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    DateFormat df = DateFormat.getDateTimeInstance(2, 0);
                    df.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return aDate.date == null ? new ESString("NaN") : new ESString(df.format(aDate.date));
                }
            }
            datePrototype.putHiddenProperty("toGMTString", new DatePrototypeToGMTString("toGMTString", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("toUTCString", new DatePrototypeToGMTString("toUTCString", evaluator, functionPrototype));
            class DatePrototypeValueOf
            extends BuiltinFunctionObject {
                DatePrototypeValueOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    if (aDate.date == null) {
                        return new ESNumber(Double.NaN);
                    }
                    long t = aDate.date.getTime();
                    return new ESNumber(t);
                }
            }
            datePrototype.putHiddenProperty("valueOf", new DatePrototypeValueOf("valueOf", evaluator, functionPrototype));
            datePrototype.putHiddenProperty("getTime", new DatePrototypeValueOf("getTime", evaluator, functionPrototype));
            class DatePrototypeGetYear
            extends BuiltinFunctionObject {
                DatePrototypeGetYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    ESValue v = aDate.get(1);
                    return new ESNumber(v.doubleValue() - 1900.0);
                }
            }
            datePrototype.putHiddenProperty("getYear", new DatePrototypeGetYear("getYear", evaluator, functionPrototype));
            class DatePrototypeGetFullYear
            extends BuiltinFunctionObject {
                DatePrototypeGetFullYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(1);
                }
            }
            datePrototype.putHiddenProperty("getFullYear", new DatePrototypeGetFullYear("getFullYear", evaluator, functionPrototype));
            class DatePrototypeGetUTCFullYear
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCFullYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(1);
                }
            }
            datePrototype.putHiddenProperty("getUTCFullYear", new DatePrototypeGetUTCFullYear("getUTCFullYear", evaluator, functionPrototype));
            class DatePrototypeGetMonth
            extends BuiltinFunctionObject {
                DatePrototypeGetMonth(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(2);
                }
            }
            datePrototype.putHiddenProperty("getMonth", new DatePrototypeGetMonth("getMonth", evaluator, functionPrototype));
            class DatePrototypeGetUTCMonth
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCMonth(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(2);
                }
            }
            datePrototype.putHiddenProperty("getUTCMonth", new DatePrototypeGetUTCMonth("getUTCMonth", evaluator, functionPrototype));
            class DatePrototypeGetDate
            extends BuiltinFunctionObject {
                DatePrototypeGetDate(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(5);
                }
            }
            datePrototype.putHiddenProperty("getDate", new DatePrototypeGetDate("getDate", evaluator, functionPrototype));
            class DatePrototypeGetUTCDate
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCDate(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(5);
                }
            }
            datePrototype.putHiddenProperty("getUTCDate", new DatePrototypeGetUTCDate("getUTCDate", evaluator, functionPrototype));
            class DatePrototypeGetDay
            extends BuiltinFunctionObject {
                DatePrototypeGetDay(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(7);
                }
            }
            datePrototype.putHiddenProperty("getDay", new DatePrototypeGetDay("getDay", evaluator, functionPrototype));
            class DatePrototypeGetUTCDay
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCDay(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(7);
                }
            }
            datePrototype.putHiddenProperty("getUTCDay", new DatePrototypeGetUTCDay("getUTCDay", evaluator, functionPrototype));
            class DatePrototypeGetHours
            extends BuiltinFunctionObject {
                DatePrototypeGetHours(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(11);
                }
            }
            datePrototype.putHiddenProperty("getHours", new DatePrototypeGetHours("getHours", evaluator, functionPrototype));
            class DatePrototypeGetUTCHours
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCHours(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(11);
                }
            }
            datePrototype.putHiddenProperty("getUTCHours", new DatePrototypeGetUTCHours("getUTCHours", evaluator, functionPrototype));
            class DatePrototypeGetMinutes
            extends BuiltinFunctionObject {
                DatePrototypeGetMinutes(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(12);
                }
            }
            datePrototype.putHiddenProperty("getMinutes", new DatePrototypeGetMinutes("getMinutes", evaluator, functionPrototype));
            class DatePrototypeGetUTCMinutes
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCMinutes(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(12);
                }
            }
            datePrototype.putHiddenProperty("getUTCMinutes", new DatePrototypeGetUTCMinutes("getUTCMinutes", evaluator, functionPrototype));
            class DatePrototypeGetSeconds
            extends BuiltinFunctionObject {
                DatePrototypeGetSeconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(13);
                }
            }
            datePrototype.putHiddenProperty("getSeconds", new DatePrototypeGetSeconds("getSeconds", evaluator, functionPrototype));
            class DatePrototypeGetUTCSeconds
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCSeconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(13);
                }
            }
            datePrototype.putHiddenProperty("getUTCSeconds", new DatePrototypeGetUTCSeconds("getUTCSeconds", evaluator, functionPrototype));
            class DatePrototypeGetMilliseconds
            extends BuiltinFunctionObject {
                DatePrototypeGetMilliseconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.get(14);
                }
            }
            datePrototype.putHiddenProperty("getMilliseconds", new DatePrototypeGetMilliseconds("getMilliseconds", evaluator, functionPrototype));
            class DatePrototypeGetUTCMilliseconds
            extends BuiltinFunctionObject {
                DatePrototypeGetUTCMilliseconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.getUTC(14);
                }
            }
            datePrototype.putHiddenProperty("getUTCMilliseconds", new DatePrototypeGetUTCMilliseconds("getUTCMilliseconds", evaluator, functionPrototype));
            class DatePrototypeSetYear
            extends BuiltinFunctionObject {
                DatePrototypeSetYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    ESValue v = aDate.get(1);
                    return aDate.setYear(arguments);
                }
            }
            datePrototype.putHiddenProperty("setYear", new DatePrototypeSetYear("setYear", evaluator, functionPrototype));
            class DatePrototypeSetFullYear
            extends BuiltinFunctionObject {
                DatePrototypeSetFullYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{1, 2, 5});
                }
            }
            datePrototype.putHiddenProperty("setFullYear", new DatePrototypeSetFullYear("setFullYear", evaluator, functionPrototype));
            class DatePrototypeSetUTCFullYear
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCFullYear(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{1, 2, 5});
                }
            }
            datePrototype.putHiddenProperty("setUTCFullYear", new DatePrototypeSetUTCFullYear("setUTCFullYear", evaluator, functionPrototype));
            class DatePrototypeSetMonth
            extends BuiltinFunctionObject {
                DatePrototypeSetMonth(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{2, 5});
                }
            }
            datePrototype.putHiddenProperty("setMonth", new DatePrototypeSetMonth("setMonth", evaluator, functionPrototype));
            class DatePrototypeSetUTCMonth
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCMonth(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{2, 5});
                }
            }
            datePrototype.putHiddenProperty("setUTCMonth", new DatePrototypeSetUTCMonth("setUTCMonth", evaluator, functionPrototype));
            class DatePrototypeSetDate
            extends BuiltinFunctionObject {
                DatePrototypeSetDate(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{5});
                }
            }
            datePrototype.putHiddenProperty("setDate", new DatePrototypeSetDate("setDate", evaluator, functionPrototype));
            class DatePrototypeSetUTCDate
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCDate(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{5});
                }
            }
            datePrototype.putHiddenProperty("setUTCDate", new DatePrototypeSetUTCDate("setUTCDate", evaluator, functionPrototype));
            class DatePrototypeSetHours
            extends BuiltinFunctionObject {
                DatePrototypeSetHours(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{11, 12, 13, 14});
                }
            }
            datePrototype.putHiddenProperty("setHours", new DatePrototypeSetHours("setHours", evaluator, functionPrototype));
            class DatePrototypeSetUTCHours
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCHours(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{11, 12, 13, 14});
                }
            }
            datePrototype.putHiddenProperty("setUTCHours", new DatePrototypeSetUTCHours("setUTCHours", evaluator, functionPrototype));
            class DatePrototypeSetMinutes
            extends BuiltinFunctionObject {
                DatePrototypeSetMinutes(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{12, 13, 14});
                }
            }
            datePrototype.putHiddenProperty("setMinutes", new DatePrototypeSetMinutes("setMinutes", evaluator, functionPrototype));
            class DatePrototypeSetUTCMinutes
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCMinutes(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{12, 13, 14});
                }
            }
            datePrototype.putHiddenProperty("setUTCMinutes", new DatePrototypeSetUTCMinutes("setUTCMinutes", evaluator, functionPrototype));
            class DatePrototypeSetSeconds
            extends BuiltinFunctionObject {
                DatePrototypeSetSeconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{13, 14});
                }
            }
            datePrototype.putHiddenProperty("setSeconds", new DatePrototypeSetSeconds("setSeconds", evaluator, functionPrototype));
            class DatePrototypeSetUTCSeconds
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCSeconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{13, 14});
                }
            }
            datePrototype.putHiddenProperty("setUTCSeconds", new DatePrototypeSetUTCSeconds("setUTCSeconds", evaluator, functionPrototype));
            class DatePrototypeSetMilliseconds
            extends BuiltinFunctionObject {
                DatePrototypeSetMilliseconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setTime(arguments, new int[]{14});
                }
            }
            datePrototype.putHiddenProperty("setMilliseconds", new DatePrototypeSetMilliseconds("setMilliseconds", evaluator, functionPrototype));
            class DatePrototypeSetUTCMilliseconds
            extends BuiltinFunctionObject {
                DatePrototypeSetUTCMilliseconds(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    return aDate.setUTCTime(arguments, new int[]{14});
                }
            }
            datePrototype.putHiddenProperty("setUTCMilliseconds", new DatePrototypeSetUTCMilliseconds("setUTCMilliseconds", evaluator, functionPrototype));
            class DatePrototypeGetTimezoneOffset
            extends BuiltinFunctionObject {
                DatePrototypeGetTimezoneOffset(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
                    cal.setTime(aDate.date);
                    TimeZone tz = cal.getTimeZone();
                    int offset = tz.getOffset(cal.get(0), cal.get(1), cal.get(2), cal.get(5), cal.get(7), cal.get(11) * 3600000 + cal.get(12) * 60000 + cal.get(13) * 1000);
                    int minutes = -(offset / 1000 / 60);
                    return new ESNumber(minutes);
                }
            }
            datePrototype.putHiddenProperty("getTimezoneOffset", new DatePrototypeGetTimezoneOffset("getTimezoneOffset", evaluator, functionPrototype));
            class DatePrototypeSetTime
            extends BuiltinFunctionObject {
                DatePrototypeSetTime(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    DatePrototype aDate = (DatePrototype)thisObject;
                    double dateValue = Double.NaN;
                    if (arguments.length > 0) {
                        dateValue = arguments[0].doubleValue();
                    }
                    aDate.date = Double.isNaN(dateValue) ? null : new Date((long)dateValue);
                    return new ESNumber(dateValue);
                }
            }
            datePrototype.putHiddenProperty("setTime", new DatePrototypeSetTime("setTime", evaluator, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        evaluator.setDatePrototype(datePrototype);
        return dateObject;
    }
}

