/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BooleanPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class BooleanObject
extends BuiltinFunctionObject {
    private BooleanObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "Boolean", 1);
    }

    public String toString() {
        return "<Boolean>";
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        if (arguments.length == 0) {
            return ESBoolean.makeBoolean(false);
        }
        return ESBoolean.makeBoolean(arguments[0].booleanValue());
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        BooleanPrototype theObject = null;
        ESObject bp = this.evaluator.getBooleanPrototype();
        theObject = new BooleanPrototype(bp, this.evaluator);
        theObject.value = arguments.length > 0 ? ESBoolean.makeBoolean(arguments[0].booleanValue()) : ESBoolean.makeBoolean(false);
        return theObject;
    }

    public static BooleanObject makeBooleanObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        BooleanPrototype booleanPrototype = new BooleanPrototype(objectPrototype, evaluator);
        BooleanObject booleanObject = new BooleanObject(functionPrototype, evaluator);
        try {
            booleanObject.putHiddenProperty("prototype", booleanPrototype);
            booleanObject.putHiddenProperty("length", new ESNumber(1.0));
            booleanPrototype.putHiddenProperty("constructor", booleanObject);
            class BooleanPrototypeToString
            extends BuiltinFunctionObject {
                BooleanPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ESBoolean v = ((BooleanPrototype)thisObject).value;
                    String s = ((Object)v).toString();
                    return new ESString(s);
                }
            }
            booleanPrototype.putHiddenProperty("toString", new BooleanPrototypeToString("toString", evaluator, functionPrototype));
            class BooleanPrototypeValueOf
            extends BuiltinFunctionObject {
                BooleanPrototypeValueOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    return ((BooleanPrototype)thisObject).value;
                }
            }
            booleanPrototype.putHiddenProperty("valueOf", new BooleanPrototypeValueOf("valueOf", evaluator, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        evaluator.setBooleanPrototype(booleanPrototype);
        return booleanObject;
    }
}

