/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class ArrayObject
extends BuiltinFunctionObject {
    private static final String JOINstring = "join".intern();
    private static final int JOINhash = JOINstring.hashCode();
    private static final String LENGTHstring = "length".intern();
    private static final int LENGTHhash = LENGTHstring.hashCode();
    private static final String ZEROstring = "0".intern();
    private static final int ZEROhash = ZEROstring.hashCode();

    private ArrayObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "Array", 1);
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        return this.doConstruct(thisObject, arguments);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        ESObject ap = this.evaluator.getArrayPrototype();
        ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
        if (arguments.length > 1) {
            for (int i = 0; i < arguments.length; ++i) {
                String iString = Integer.toString(i);
                theArray.putProperty(iString, arguments[i], iString.hashCode());
            }
        } else if (arguments.length == 1) {
            ESValue firstArg = arguments[0];
            if (firstArg.isNumberValue()) {
                int length = firstArg.toInt32();
                theArray.putProperty(LENGTHstring, firstArg, LENGTHhash);
            } else {
                theArray.putProperty(ZEROstring, firstArg, ZEROhash);
            }
        }
        return theArray;
    }

    public static ArrayObject makeArrayObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        ArrayPrototype arrayPrototype = new ArrayPrototype(objectPrototype, evaluator);
        ArrayObject arrayObject = new ArrayObject(functionPrototype, evaluator);
        try {
            arrayObject.putHiddenProperty("prototype", arrayPrototype);
            arrayObject.putHiddenProperty(LENGTHstring, new ESNumber(1.0));
            arrayPrototype.putHiddenProperty("constructor", arrayObject);
            class ArrayPrototypeToString
            extends BuiltinFunctionObject {
                ArrayPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    BuiltinFunctionObject join = (BuiltinFunctionObject)thisObject.getProperty(JOINstring, JOINhash);
                    return join.callFunction(thisObject, new ESValue[0]);
                }
            }
            arrayPrototype.putHiddenProperty("toString", new ArrayPrototypeToString("toString", evaluator, functionPrototype));
            class ArrayPrototypeJoin
            extends BuiltinFunctionObject {
                ArrayPrototypeJoin(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    StringBuffer buffer = new StringBuffer();
                    String separator = ",";
                    if (arguments.length > 0) {
                        separator = arguments[0].toString();
                    }
                    int length = thisObject.getProperty(LENGTHstring, LENGTHhash).toInt32();
                    for (int i = 0; i < length; ++i) {
                        String iString;
                        ESValue value;
                        if (i > 0) {
                            buffer.append(separator);
                        }
                        if ((value = thisObject.getProperty(iString = Integer.toString(i), iString.hashCode())) == ESUndefined.theUndefined || value == ESNull.theNull) continue;
                        buffer.append(value.toString());
                    }
                    return new ESString(buffer.toString());
                }
            }
            arrayPrototype.putHiddenProperty("join", new ArrayPrototypeJoin("join", evaluator, functionPrototype));
            class ArrayPrototypeReverse
            extends BuiltinFunctionObject {
                ArrayPrototypeReverse(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 0);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (!(thisObject instanceof ArrayPrototype)) {
                        throw new EcmaScriptException("reverse only implemented for arrays");
                    }
                    return ((ArrayPrototype)thisObject).reverse();
                }
            }
            arrayPrototype.putHiddenProperty("reverse", new ArrayPrototypeReverse("reverse", evaluator, functionPrototype));
            class ArrayPrototypeSort
            extends BuiltinFunctionObject {
                ArrayPrototypeSort(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    if (!(thisObject instanceof ArrayPrototype)) {
                        throw new EcmaScriptException("sort only implemented for arrays");
                    }
                    ESValue compareFn = null;
                    if (arguments.length > 0) {
                        compareFn = arguments[0];
                    }
                    return ((ArrayPrototype)thisObject).sort(compareFn);
                }
            }
            arrayPrototype.putHiddenProperty("sort", new ArrayPrototypeSort("sort", evaluator, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        evaluator.setArrayPrototype(arrayPrototype);
        return arrayObject;
    }
}

