/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.ClassFile;
import FESI.ClassFile.ConstantPoolEntry;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;

class NameAndTypeConstant
extends ConstantPoolEntry {
    private UTF8Constant name;
    private UTF8Constant desc;

    NameAndTypeConstant(String n, String d, ClassFile cf) {
        super((byte)12, cf);
        this.name = new UTF8Constant(n, cf);
        this.desc = new UTF8Constant(d, cf);
        this.addToConstantPool();
    }

    void write(DataOutputStream dos) throws IOException {
        if (NameAndTypeConstant.debug()) {
            System.err.println(this.getConstantPoolIndex() + " NAME: " + this.name.getConstantPoolIndex() + " TYPE: " + this.desc.getConstantPoolIndex());
        }
        dos.writeByte(this.getTag());
        dos.writeShort(this.name.getConstantPoolIndex());
        dos.writeShort(this.desc.getConstantPoolIndex());
    }

    String getName() {
        return this.name.getString();
    }

    String getDescriptor() {
        return this.desc.getString();
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.name.getString().equals(o) || this.desc.getString().equals(o);
        }
        if (o instanceof NameAndTypeConstant) {
            NameAndTypeConstant nandt = (NameAndTypeConstant)o;
            return this.name.equals(nandt.getName()) && this.desc.equals(nandt.getDescriptor());
        }
        return false;
    }
}

