/*
 * Decompiled with CFR 0.152.
 */
package FESI.AST;

import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.AST.SimpleNode;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;

public class ASTLiteral
extends SimpleNode {
    private ESValue theValue = null;

    public ASTLiteral(int id) {
        super(id);
    }

    public ASTLiteral(EcmaScript p, int id) {
        super(p, id);
    }

    public static Node jjtCreate(int id) {
        return new ASTLiteral(id);
    }

    public static Node jjtCreate(EcmaScript p, int id) {
        return new ASTLiteral(p, id);
    }

    public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public ESValue getValue() {
        return this.theValue;
    }

    static final int hexval(char c) throws ProgrammingError {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new ProgrammingError("Illegal hex or unicode constant");
    }

    static final int octval(char c) throws ProgrammingError {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new ProgrammingError("Illegal octal constant");
    }

    public void setStringValue(String image) {
        int l = image.length();
        StringBuffer sb = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            int c = image.charAt(i);
            if (c == 92 && i + 1 < l) {
                if ((c = image.charAt(++i)) == 110) {
                    c = 10;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 120) {
                    c = (char)(ASTLiteral.hexval(image.charAt(i + 1)) << 4 | ASTLiteral.hexval(image.charAt(i + 1)));
                    i += 2;
                } else if (c == 117) {
                    c = (char)(ASTLiteral.hexval(image.charAt(i + 1)) << 12 | ASTLiteral.hexval(image.charAt(i + 2)) << 8 | ASTLiteral.hexval(image.charAt(i + 3)) << 4 | ASTLiteral.hexval(image.charAt(i + 4)));
                    i += 4;
                } else if (c >= 48 && c <= 55) {
                    c = (char)ASTLiteral.octval(image.charAt(i));
                    if (image.length() > i && image.charAt(i + 1) >= '0' && image.charAt(i + 1) <= '7') {
                        c = (char)(c << 4 | ASTLiteral.octval(image.charAt(++i)));
                    }
                }
            }
            sb.append((char)c);
        }
        this.theValue = new ESString(sb.toString());
    }

    public void setDecimalValue(String image) {
        try {
            this.theValue = new ESNumber(Long.parseLong(image));
        }
        catch (NumberFormatException e) {
            Double value = new Double(image);
            this.theValue = new ESNumber(value);
        }
    }

    public void setOctalValue(String image) {
        try {
            String imageWithout0 = image.substring(1);
            this.theValue = new ESNumber(Long.parseLong(imageWithout0, 8));
        }
        catch (NumberFormatException e) {
            Double value = new Double(image);
            this.theValue = new ESNumber(value);
        }
    }

    public void setHexValue(String image) {
        try {
            String imageWithout0x = image.substring(2);
            this.theValue = new ESNumber(Long.parseLong(imageWithout0x, 16));
        }
        catch (NumberFormatException e) {
            Double value = new Double(image);
            this.theValue = new ESNumber(value);
        }
    }

    public void setFloatingPointValue(String image) {
        Double value = new Double(image);
        this.theValue = new ESNumber(value);
    }

    public void setBooleanValue(boolean value) {
        this.theValue = ESBoolean.makeBoolean(value);
    }

    public void setNullValue() {
        this.theValue = ESNull.theNull;
    }

    public void setUndefinedValue() {
        this.theValue = ESUndefined.theUndefined;
    }

    public String toString() {
        return "[" + this.theValue.toString() + "]";
    }
}

