/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.postgresql.Connection;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.util.PSQLException;

public class QueryExecutor {
    private final String sql;
    private final Statement statement;
    private final PG_Stream pg_stream;
    private final Connection connection;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private boolean binaryCursor = false;
    private String status = null;
    private int update_count = 1;
    private long insert_oid = 0L;
    private int maxRows;

    public QueryExecutor(String string, Statement statement, PG_Stream pG_Stream, Connection connection) throws SQLException {
        this.sql = string;
        this.statement = statement;
        this.pg_stream = pG_Stream;
        this.connection = connection;
        this.maxRows = statement != null ? statement.getMaxRows() : 0;
    }

    public ResultSet execute() throws SQLException {
        int n = 0;
        boolean bl = false;
        PG_Stream pG_Stream = this.pg_stream;
        synchronized (pG_Stream) {
            this.sendQuery(this.sql);
            block15: while (!bl || n > 0) {
                int n2 = this.pg_stream.ReceiveChar();
                switch (n2) {
                    case 65: {
                        int n3 = this.pg_stream.ReceiveInteger(4);
                        String string = this.pg_stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 66: {
                        this.receiveTuple(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatus();
                        if (this.fields != null) {
                            bl = true;
                            break;
                        }
                        this.sendQuery(" ");
                        ++n;
                        break;
                    }
                    case 68: {
                        this.receiveTuple(false);
                        break;
                    }
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(this.connection.getEncoding()));
                    }
                    case 73: {
                        int n4 = this.pg_stream.ReceiveChar();
                        if (n4 != 0) {
                            throw new PSQLException("postgresql.con.garbled");
                        }
                        if (n > 0) {
                            --n;
                        }
                        if (n != 0) continue block15;
                        bl = true;
                        break;
                    }
                    case 78: {
                        this.connection.addWarning(this.pg_stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 80: {
                        String string = this.pg_stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 84: {
                        this.receiveFields();
                        break;
                    }
                    case 90: {
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)n2));
                    }
                }
            }
            ResultSet resultSet = this.connection.getResultSet(this.connection, this.statement, this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
            return resultSet;
        }
    }

    private void sendQuery(String string) throws SQLException {
        try {
            this.pg_stream.SendChar(81);
            this.pg_stream.Send(this.connection.getEncoding().encode(string));
            this.pg_stream.SendChar(0);
            this.pg_stream.flush();
        }
        catch (IOException iOException) {
            throw new PSQLException("postgresql.con.ioerror", iOException);
        }
    }

    private void receiveTuple(boolean bl) throws SQLException {
        if (this.fields == null) {
            throw new PSQLException("postgresql.con.tuple");
        }
        byte[][] byArray = this.pg_stream.ReceiveTuple(this.fields.length, bl);
        if (bl) {
            this.binaryCursor = true;
        }
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(byArray);
        }
    }

    private void receiveCommandStatus() throws SQLException {
        this.status = this.pg_stream.ReceiveString(this.connection.getEncoding());
        try {
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.con.fathom", (Object)this.status);
        }
    }

    private void receiveFields() throws SQLException {
        if (this.fields != null) {
            throw new PSQLException("postgresql.con.multres");
        }
        int n = this.pg_stream.ReceiveIntegerR(2);
        this.fields = new Field[n];
        int n2 = 0;
        while (n2 < this.fields.length) {
            String string = this.pg_stream.ReceiveString(this.connection.getEncoding());
            int n3 = this.pg_stream.ReceiveIntegerR(4);
            int n4 = this.pg_stream.ReceiveIntegerR(2);
            int n5 = this.pg_stream.ReceiveIntegerR(4);
            this.fields[n2] = new Field(this.connection, string, n3, n4, n5);
            ++n2;
        }
    }
}

