/*
 *  Copyright (C) 2002 RealVNC Ltd.
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *
 *  This code contains original and modified parts from:
 *  - the "VGA graphics demo" from Chris Giese
 *          http://my.execpc.com/~geezer/osd/graphics/grdemo.c
 *          <geezer@execpc.com>	http://www.execpc.com/~geezer
 */

/*
 * desktop.c - functions to deal with "desktop" window.
 */

#include "viewer.h"
#include <graphics.h>
#include <dos.h>

#define VGA_SEQ_INDEX		0x3C4
#define VGA_SEQ_DATA		0x3C5
#define VGA_GC_INDEX    0x3CE
#define VGA_GC_DATA     0x3CF
/* BJ
#include <X11/Xaw/Viewport.h>
#include <X11/Xmu/Converters.h>
#ifdef MITSHM
#include <X11/extensions/XShm.h>
#endif
*/

/* BJ
GC gc;
GC srcGC, dstGC;*/ /* used for debugging copyrect */
/* BJ
Window desktopWin;
Widget form, viewport, desktop;
*/
/*
static  int   BGR233To4bits[] = {
       0, 10, 10, 10, 10, 10,  2,  2, 12, 11, 10, 10, 10, 10,  2,  2,
      12, 12, 14, 11, 10, 10,  2,  2, 12, 12, 12, 14, 14, 14,  2,  2,
      12, 12, 12, 14, 14, 14,  3,  3,  8,  8,  8,  8,  8, 15, 15, 15,
      15, 15, 15, 15, 15, 15, 15, 15,  4,  4,  4,  4,  4,  5,  6,  6,
       9,  9, 11, 11, 10, 10,  2,  2,  9,  9, 11, 11, 10, 10,  2,  2,
      13, 13, 11, 11, 11,  2,  2,  2, 13, 13, 13, 14, 14, 14,  2,  3,
      12, 12, 13,  8,  8,  8,  3,  3,  8,  8,  8,  8,  3, 15, 15, 15,
      15, 15, 15, 15, 15, 15, 15, 15,  4,  4,  4,  4,  5,  5,  6,  6,
       9,  9,  9, 11, 11, 11,  2,  2,  9,  9,  9, 11, 11, 11,  2,  2,
       1,  1,  1, 11, 11, 11,  3,  3, 13, 13, 13,  8,  8,  8,  3,  3,
      13, 13, 13,  8,  8,  3,  3,  3,  8,  8,  8,  8,  3, 15, 15, 15,
      15, 15, 15, 15, 15, 15, 15,  4,  4,  4,  4,  5,  5,  5,  6,  6,
       1,  1,  1,  1,  1,  8,  3,  3,  1,  1,  1,  1,  1,  8,  3,  3,
       1,  1,  1,  1,  8,  8,  3,  3,  1,  1,  1,  8,  8,  3,  3,  3,
      13, 13,  8,  8,  3,  3,  3, 15, 15, 15, 15, 15, 15, 15, 15, 15,
      15, 15, 15, 15, 15, 15,  5,  5,  5,  5,  5,  5,  5,  6,  6,  7
} ;*/
static Bool modifierPressed[256];

/* BJ
static XImage *image = NULL;

static Cursor CreateDotCursor();
*/
static void CopyBGR233ToScreen(CARD8 *buf, int x, int y, int width,int height);
/* BJ
static void HandleBasicDesktopEvent(Widget w, XtPointer ptr, XEvent *ev,
				    Boolean *cont);
*/

static void write_pixel4p(unsigned x, unsigned y, unsigned c);
void set_plane(unsigned p);
static void write_bitmap4p(char *buff, int x, int y, int width, int height);
static void read_bitmap4p(char *buff, int x, int y, int width, int height);
void fill_rect4p(int color, int x, int y, int wd, int ht);
/* BJ
static XtResource desktopBackingStoreResources[] = {
  {
    XtNbackingStore, XtCBackingStore, XtRBackingStore, sizeof(int), 0,
    XtRImmediate, (XtPointer) Always,
  },
};
*/


/*
 * DesktopInitBeforeRealization creates the "desktop" widget and the viewport
 * which controls it.
 */

void
DesktopInitBeforeRealization()
{
  int i, ht, y, xmax,errorcode;
  int GraphDriver = VGA;
  int GraphMode = VGAHI;
  struct palettetype pal;

  printf(" Graphics System Initialization...\n");
  initgraph( &GraphDriver, &GraphMode, "" );
   /* read result of initialization */
   errorcode = graphresult();
   if (errorcode != grOk) {  /* an error occurred */

      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);               /* terminate with an error code */
   }


  /* Set a 16 grey levels palette */
  getpalette(&pal);
  for (i = 0; i < pal.size; i++) {
    setrgbpalette(pal.colors[i],i*4,i*4,i*4);
  }


/* BJ
  form = XtVaCreateManagedWidget("form", formWidgetClass, toplevel,
				 XtNborderWidth, 0,
				 XtNdefaultDistance, 0, NULL);

  viewport = XtVaCreateManagedWidget("viewport", viewportWidgetClass, form,
				     XtNborderWidth, 0,
				     NULL);

  desktop = XtVaCreateManagedWidget("desktop", coreWidgetClass, viewport,
				    XtNborderWidth, 0,
				    NULL);

  XtVaSetValues(desktop, XtNwidth, si.framebufferWidth,
		XtNheight, si.framebufferHeight, NULL);

  XtAddEventHandler(desktop, LeaveWindowMask|ExposureMask,
		    True, HandleBasicDesktopEvent, NULL);
*/
  for (i = 0; i < 256; i++)
    modifierPressed[i] = False;
/* BJ
  image = NULL;

#ifdef MITSHM
  if (appData.useShm) {
    image = CreateShmImage();
    if (!image)
      appData.useShm = False;
  }
#endif

  if (!image) {
    image = XCreateImage(dpy, vis, visdepth, ZPixmap, 0, NULL,
			 si.framebufferWidth, si.framebufferHeight,
			 BitmapPad(dpy), 0);

    image->data = malloc(image->bytes_per_line * image->height);
    if (!image->data) {
      fprintf(stderr,"malloc failed\n");
      exit(1);
    }
  }
  */
}


/*
 * DesktopInitAfterRealization does things which require the X windows to
 * exist.  It creates some GCs and sets the dot cursor.
 */

/* BJ
void
DesktopInitAfterRealization()
{
  XGCValues gcv;
  XSetWindowAttributes attr;

  desktopWin = XtWindow(desktop);

  gc = XCreateGC(dpy,desktopWin,0,NULL);

  gcv.function = GXxor;
  gcv.foreground = 0x0f0f0f0f;
  srcGC = XCreateGC(dpy,desktopWin,GCFunction|GCForeground,&gcv);
  gcv.foreground = 0xf0f0f0f0;
  dstGC = XCreateGC(dpy,desktopWin,GCFunction|GCForeground,&gcv);

  XtAddConverter(XtRString, XtRBackingStore, XmuCvtStringToBackingStore,
		 NULL, 0);

  XtVaGetApplicationResources(desktop, (XtPointer)&attr.backing_store,
			      desktopBackingStoreResources, 1, NULL);

  attr.cursor = CreateDotCursor();

  XChangeWindowAttributes(dpy, desktopWin, CWBackingStore|CWCursor, &attr);
}
*/


/*
 * HandleBasicDesktopEvent - deal with expose and leave events.
 */

/* BJ
static void
HandleBasicDesktopEvent(Widget w, XtPointer ptr, XEvent *ev, Boolean *cont)
{
  int i;

  switch (ev->type) {

  case Expose:
  case GraphicsExpose:
*/
    /* sometimes due to scrollbars being added/removed we get an expose outside
       the actual desktop area.  Make sure we don't pass it on to the RFB
       server. */
/*
    if (ev->xexpose.x + ev->xexpose.width > si.framebufferWidth) {
      ev->xexpose.width = si.framebufferWidth - ev->xexpose.x;
      if (ev->xexpose.width <= 0) break;
    }

    if (ev->xexpose.y + ev->xexpose.height > si.framebufferHeight) {
      ev->xexpose.height = si.framebufferHeight - ev->xexpose.y;
      if (ev->xexpose.height <= 0) break;
    }

    UpdateNeeded(ev->xexpose.x, ev->xexpose.y,
                 ev->xexpose.width, ev->xexpose.height);
    break;

  case LeaveNotify:
    for (i = 0; i < 256; i++) {
      if (modifierPressed[i]) {
	SendKeyEvent(XKeycodeToKeysym(dpy, i, 0), False);
	modifierPressed[i] = False;
      }
    }
    break;
  }
}
*/

/*
 * SendRFBEvent is an action which sends an RFB event.  It can be used in two
 * ways.  Without any parameters it simply sends an RFB event corresponding to
 * the X event which caused it to be called.  With parameters, it generates a
 * "fake" RFB event based on those parameters.  The first parameter is the
 * event type, either "ptr", "keydown", "keyup" or "key" (down&up).  For a
 * "key" event the second parameter is simply a keysym string as understood by
 * XStringToKeysym().  For a "ptr" event, the following three parameters are
 * just X, Y and the button mask (0 for all up, 1 for button1 down, 2 for
 * button2 down, 3 for both, etc).
 */

/* BJ
void
SendRFBEvent(Widget w, XEvent *ev, String *params, Cardinal *num_params)
{
  KeySym ks;
  char keyname[256];
  int buttonMask, x, y;

  if (appData.fullScreen && ev->type == MotionNotify) {
    if (BumpScroll(ev))
      return;
  }

  if (appData.viewOnly) return;

  if (*num_params != 0) {
    if (strncasecmp(params[0],"key",3) == 0) {
      if (*num_params != 2) {
	fprintf(stderr,
		"Invalid params: SendRFBEvent(key|keydown|keyup,<keysym>)\n");
	return;
      }
      ks = XStringToKeysym(params[1]);
      if (ks == NoSymbol) {
	fprintf(stderr,"Invalid keysym '%s' passed to SendRFBEvent\n",
		params[1]);
	return;
      }
      if (strcasecmp(params[0],"keydown") == 0) {
	SendKeyEvent(ks, 1);
      } else if (strcasecmp(params[0],"keyup") == 0) {
	SendKeyEvent(ks, 0);
      } else if (strcasecmp(params[0],"key") == 0) {
	SendKeyEvent(ks, 1);
	SendKeyEvent(ks, 0);
      } else {
	fprintf(stderr,"Invalid event '%s' passed to SendRFBEvent\n",
		params[0]);
	return;
      }
    } else if (strcasecmp(params[0],"ptr") == 0) {
      if (*num_params == 4) {
	x = atoi(params[1]);
	y = atoi(params[2]);
	buttonMask = atoi(params[3]);
	SendPointerEvent(x, y, buttonMask);
      } else if (*num_params == 2) {
	switch (ev->type) {
	case ButtonPress:
	case ButtonRelease:
	  x = ev->xbutton.x;
	  y = ev->xbutton.y;
	  break;
	case KeyPress:
	case KeyRelease:
	  x = ev->xkey.x;
	  y = ev->xkey.y;
	  break;
	default:
	  fprintf(stderr,
		  "Invalid event caused SendRFBEvent(ptr,<buttonMask>)\n");
	  return;
	}
	buttonMask = atoi(params[1]);
	SendPointerEvent(x, y, buttonMask);
      } else {
	fprintf(stderr,
		"Invalid params: SendRFBEvent(ptr,<x>,<y>,<buttonMask>)\n"
		"             or SendRFBEvent(ptr,<buttonMask>)\n");
	return;
      }

    } else {
      fprintf(stderr,"Invalid event '%s' passed to SendRFBEvent\n", params[0]);
    }
    return;
  }

  switch (ev->type) {

  case MotionNotify:
    while (XCheckTypedWindowEvent(dpy, desktopWin, MotionNotify, ev));
*/
      	/* discard all queued motion notify events */
/*
    SendPointerEvent(ev->xmotion.x, ev->xmotion.y,
		     (ev->xmotion.state & 0x1f00) >> 8);
    return;

  case ButtonPress:
    SendPointerEvent(ev->xbutton.x, ev->xbutton.y,
		     (((ev->xbutton.state & 0x1f00) >> 8) |
		      (1 << (ev->xbutton.button - 1))));
    return;

  case ButtonRelease:
    SendPointerEvent(ev->xbutton.x, ev->xbutton.y,
		     (((ev->xbutton.state & 0x1f00) >> 8) &
		      ~(1 << (ev->xbutton.button - 1))));
    return;

  case KeyPress:
  case KeyRelease:
    XLookupString(&ev->xkey, keyname, 256, &ks, NULL);

    if (IsModifierKey(ks)) {
      ks = XKeycodeToKeysym(dpy, ev->xkey.keycode, 0);
      modifierPressed[ev->xkey.keycode] = (ev->type == KeyPress);
    }

    SendKeyEvent(ks, (ev->type == KeyPress));
    return;

  default:
    fprintf(stderr,"Invalid event passed to SendRFBEvent\n");
  }
}
*/


/*
 * CreateDotCursor.
 */
/*
static Cursor
CreateDotCursor()
{
  Cursor cursor;
  Pixmap src, msk;
  static char srcBits[] = { 0, 14,14,14, 0 };
  static char mskBits[] = { 31,31,31,31,31 };
  XColor fg, bg;

  src = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), srcBits, 5, 5);
  msk = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), mskBits, 5, 5);
  XAllocNamedColor(dpy, DefaultColormap(dpy,DefaultScreen(dpy)), "black",
		   &fg, &fg);
  XAllocNamedColor(dpy, DefaultColormap(dpy,DefaultScreen(dpy)), "white",
		   &bg, &bg);
  cursor = XCreatePixmapCursor(dpy, src, msk, &fg, &bg, 2, 2);
  XFreePixmap(dpy, src);
  XFreePixmap(dpy, msk);

  return cursor;
}
*/

/*
 * CopyDataToScreen.
 */

void
CopyDataToScreen(char *buf, int x, int y, int width, int height)
{
  long nb_pixels = width * height;
  int i;
  int pixel_red,pixel_green,pixel_blue;
  int pixel_x,pixel_y;
  char pixel_color;
 
  /* Convert the 256 colors bgr233 format into a 16 grey level */
  for (i = 0; i < nb_pixels; i++) {
      pixel_red = (buf[i]>>myFormat.redShift)&0x7;
      pixel_green = (buf[i]>>myFormat.greenShift)&0x7;
      pixel_blue = (buf[i]>>myFormat.blueShift)&0x3;
      pixel_color = (pixel_red + pixel_green + pixel_blue)-2;
      if (pixel_color < 0) {
        pixel_color = 0;
      }      
      buf[i] = pixel_color;
/*      pixel_x = x + i%width;
      pixel_y = y + i / width;
      write_pixel4p(pixel_x,pixel_y,buf[i]);*/
  }
  write_bitmap4p(buf, x, y, width, height);
  
/* BJ
  if (appData.rawDelay != 0) {
    XFillRectangle(dpy, desktopWin, gc, x, y, width, height);

    XSync(dpy,False);

    usleep(appData.rawDelay * 1000);
  }

  if (!usingBGR233) {
    int h;
    int widthInBytes = width * myFormat.bitsPerPixel / 8;
    int scrWidthInBytes = si.framebufferWidth * myFormat.bitsPerPixel / 8;

    char *scr = (image->data + y * scrWidthInBytes
		 + x * myFormat.bitsPerPixel / 8);

    for (h = 0; h < height; h++) {
      memcpy(scr, buf, widthInBytes);
      buf += widthInBytes;
      scr += scrWidthInBytes;
    }
  } else {
    CopyBGR233ToScreen((CARD8 *)buf, x, y, width, height);
  }

#ifdef MITSHM
  if (appData.useShm) {
    XShmPutImage(dpy, desktopWin, gc, image, x, y, x, y, width, height, False);
    return;
  }
#endif
  XPutImage(dpy, desktopWin, gc, image, x, y, x, y, width, height);
*/
}

void
CopyArea(int src_x, int src_y, int width, int height, int dst_x, int dst_y)
{
  int line;
  unsigned char * area;

  area = malloc( width );
  if (!area) {
      fprintf(stderr,"Unable to allocate %d bytes\n",width);
      exit (1);
  }

  /* we copy the rectangle line by line because the area shouldn't be too big
   * and therefore cannot contains the whole rectangle.
   *  TODO: optimization by using specialized read_bitmap and write bitmap */

  /* Checks the destination position to avoid overlapping and loss of
   * information */
  if (dst_y > src_y) {
    for (line = height - 1; line >= 0; line--) {
        read_bitmap4p(area,src_x,src_y + line, width, 1);
        write_bitmap4p(area,dst_x,dst_y + line, width, 1);
    }
  } else {
    for (line = 0; line < height; line++) {
        read_bitmap4p(area,src_x,src_y + line, width, 1);
        write_bitmap4p(area,dst_x,dst_y + line, width, 1);
    }
  }
    
  free(area);
}
  
/*
 * CopyBGR233ToScreen.
 */

/* BJ
static void
CopyBGR233ToScreen(CARD8 *buf, int x, int y, int width, int height)
{
  int p, q;
  int xoff = 7 - (x & 7);
  int xcur;
  int fbwb = si.framebufferWidth / 8;
  CARD8 *scr1 = ((CARD8 *)image->data) + y * fbwb + x / 8;
  CARD8 *scrt;
  CARD8 *scr8 = ((CARD8 *)image->data) + y * si.framebufferWidth + x;
  CARD16 *scr16 = ((CARD16 *)image->data) + y * si.framebufferWidth + x;
  CARD32 *scr32 = ((CARD32 *)image->data) + y * si.framebufferWidth + x;

  switch (visbpp) {
*/
    /* thanks to Chris Hooper for single bpp support */
/* BJ
  case 1:
    for (q = 0; q < height; q++) {
      xcur = xoff;
      scrt = scr1;
      for (p = 0; p < width; p++) {
	*scrt = ((*scrt & ~(1 << xcur))
		 | (BGR233ToPixel[*(buf++)] << xcur));

	if (xcur-- == 0) {
	  xcur = 7;
	  scrt++;
	}
      }
      scr1 += fbwb;
    }
    break;

  case 8:
    for (q = 0; q < height; q++) {
      for (p = 0; p < width; p++) {
	*(scr8++) = BGR233ToPixel[*(buf++)];
      }
      scr8 += si.framebufferWidth - width;
    }
    break;

  case 16:
    for (q = 0; q < height; q++) {
      for (p = 0; p < width; p++) {
	*(scr16++) = BGR233ToPixel[*(buf++)];
      }
      scr16 += si.framebufferWidth - width;
    }
    break;

  case 32:
    for (q = 0; q < height; q++) {
      for (p = 0; p < width; p++) {
	*(scr32++) = BGR233ToPixel[*(buf++)];
      }
      scr32 += si.framebufferWidth - width;
    }
    break;
  }
}
*/

void set_plane(unsigned p)
{
    unsigned char pmask;

      p &= 3;
      pmask = 1 << p;
      outportb(VGA_GC_INDEX, 4);
      outportb(VGA_GC_DATA, p);
      outportb(VGA_SEQ_INDEX, 2);
      outportb(VGA_SEQ_DATA, pmask);
}

static void write_bitmap4p(char *buf, int x, int y, int width, int height)
{
  unsigned int line,column,col;
  unsigned wd_in_bytes, offset, mask, p, pmask;
  unsigned ptr_buff;
  unsigned char far *video_memory;
 
  video_memory = MK_FP(0xA000, 0);
	pmask = 1;
  wd_in_bytes = 640 / 8;
	for(p = 0; p < 4; p++)
	{
    ptr_buff = 0;

		set_plane(p);
    /* foreach line */
    for (line = y; line < y + height; line++) {
      /* foreach column */
      for (column = x; column < x + width; column ++) {
    
        offset = wd_in_bytes * line + column / 8;
        col = (column & 7) * 1;
        mask = 0x80 >> col;
    
      if(pmask & buf[ptr_buff])
        video_memory[offset] |= mask;
      else
        video_memory[offset] &= ~mask;

      ptr_buff++;
      }
    }
        
		pmask <<= 1;
	}
}

static void read_bitmap4p(char *buf, int x, int y, int width, int height)
{
  unsigned int line,column,col;
  unsigned wd_in_bytes, offset, p, pmask, mask;
  unsigned ptr_buff;
  unsigned char far *video_memory;

  /* Initialize buffer */
  for (ptr_buff=0; ptr_buff < width*height; ptr_buff++) {
    buf[ptr_buff] = 0;
  }
 
  video_memory = MK_FP(0xA000, 0);
	pmask = 8;
  wd_in_bytes = 640 / 8;
	for(p = 0; p < 4; p++)
	{
    ptr_buff = 0;

		set_plane(p);
    /* foreach line */
    for (line = y; line < y + height; line++) {
      /* foreach column */
      for (column = x; column < x + width; column ++) {
    
        offset = wd_in_bytes * line + column / 8;
        
        col = (column & 7) * 1;
        mask = 0x80 >> col;

        if (mask & video_memory[offset]) {
          buf[ptr_buff] |= pmask;
        }
              
      ptr_buff++;
      }
    }
        
    pmask >>= 1;
	}
}

void vmemset(unsigned char far *s, unsigned c, unsigned n)
{
	for(; n != 0; n--)
	{
		*s = c;
		s++;
	}
}

void fill_plane(int x, int y, int wd, int ht, unsigned c)
{
	unsigned w, wd_in_bytes, off;
	unsigned char lmask, rmask;
	int x2, y2;
  unsigned char far *video_memory;

  video_memory = MK_FP(0xA000, 0);

	x2 = x + wd - 1;
	w = (x2 >> 3) - (x >> 3) + 1;
	lmask = 0x00FF >> (x & 7); /* FF 7F 3F 1F 0F 07 03 01 */
	rmask = 0xFF80 >> (x2 & 7);/* 80 C0 E0 F0 F8 FC FE FF */
	if(w == 1)
		lmask &= rmask;
	wd_in_bytes = 640 / 8;
	off = wd_in_bytes * y + x / 8;
	if(c)
/* for each row... */
		for(y2 = y; y2 < y + ht; y2++)
		{
/* do partial byte on left */
			video_memory[off] |= lmask;
/* do solid bytes in middle */
			if(w > 2)
				vmemset(video_memory + off + 1,
					0xFF, w - 2);
/* do partial byte on right */
			if(w > 1)
				video_memory[off + w - 1] |= rmask;
/* next row */
			off += wd_in_bytes;
		}
	else
	{
		lmask = ~lmask;
		rmask = ~rmask;
		for(y2 = y; y2 < y + ht; y2++)
		{
			video_memory[off] &= lmask;
			if(w > 2)
				vmemset(video_memory + off + 1,
					0, w - 2);
			if(w > 1)
				video_memory[off + w - 1] &= rmask;
			off += wd_in_bytes;
		}
	}
}

void fill_rect4p(int color, int x, int y, int wd, int ht)
{
	unsigned char p, pmask;

	pmask = 1;
	for(p = 0; p < 4; p++)
	{
		set_plane(p);
		fill_plane(x, y, wd, ht, color & pmask);
		pmask <<= 1;
	}
}


void CheckKeyboard() {
  char c;
  while (kbhit()) {
    c = getch();
    SendKeyEvent(c,True);
    SendKeyEvent(c,False);
  }
}
