/*
 * Decompiled with CFR 0.152.
 */
package org.expath.ns;

import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.util.Util;

final class GeoErrors {
    private GeoErrors() {
    }

    static QueryException unrecognizedGeo(byte[] name) {
        return GeoErrors.thrw(1, "Unrecognized Geo type: %", new Object[]{name});
    }

    static QueryException gmlReaderErr(Throwable th) {
        return GeoErrors.thrw(2, "Parsing GML 2.0: %", th);
    }

    static QueryException geoType(byte[] name, String geo) {
        return GeoErrors.thrw(3, "% is not an appropriate geometry for this function. The input geometry should be a %.", name, geo);
    }

    static QueryException outOfRangeIdx(Int geoNumber) {
        return GeoErrors.thrw(4, "Out of range input index: %", geoNumber);
    }

    static QueryException gmlWriterErr(Throwable th) {
        return GeoErrors.thrw(5, "%", th);
    }

    static QueryException illegalArg(Str arg) {
        return GeoErrors.thrw(6, "Illegal argument: %", arg);
    }

    static QNm qname(int code) {
        return new QNm(Util.inf((Object)"%s:GEO%04d", (Object[])new Object[]{QueryText.EXPERR_PREFIX, code}), QueryText.EXPERROR_URI);
    }

    private static QueryException thrw(int code, String msg, Object ... ext) {
        return new QueryException(null, GeoErrors.qname(code), msg, ext);
    }
}

