/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import org.basex.http.webdav.WebDAVResource;
import org.basex.server.LoginException;
import org.basex.util.Util;

abstract class WebDAVCode<E> {
    private final WebDAVResource resource;

    WebDAVCode(WebDAVResource resource) {
        this.resource = resource;
    }

    final E eval() throws BadRequestException, NotAuthorizedException {
        try {
            E ret = this.get();
            if (ret == null) {
                this.run();
            }
            return ret;
        }
        catch (LoginException ex) {
            throw new NotAuthorizedException(Util.message((Throwable)ex), (Resource)this.resource);
        }
        catch (IOException ex) {
            throw new BadRequestException((Resource)this.resource, Util.message((Throwable)ex));
        }
    }

    final E evalNoEx() {
        try {
            return this.eval();
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            return null;
        }
    }

    E get() throws IOException {
        return null;
    }

    void run() throws IOException {
    }
}

