/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.build.text.TextOptions;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTExec;
import org.basex.http.rest.RESTSession;
import org.basex.util.http.MediaType;
import org.basex.util.options.Options;

final class RESTPut {
    private RESTPut() {
    }

    public static RESTExec get(RESTSession session) throws IOException {
        JsonParserOptions opts;
        HTTPConnection conn = session.conn;
        String db = conn.db();
        if (db.isEmpty()) {
            throw HTTPCode.NO_PATH.get(new Object[0]);
        }
        RESTCmd.parseOptions(session);
        MainOptions options = conn.context.options;
        ServletInputStream is = conn.req.getInputStream();
        MediaType mt = conn.contentType();
        boolean xml = true;
        String ct = mt.type();
        if (mt.is(MediaType.APPLICATION_JSON)) {
            opts = new JsonParserOptions();
            opts.assign(mt);
            options.set(MainOptions.JSONPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.JSON);
        } else if (mt.isCSV()) {
            opts = new CsvParserOptions();
            opts.assign(mt);
            options.set(MainOptions.CSVPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.CSV);
        } else if (mt.is(MediaType.TEXT_HTML)) {
            opts = new HtmlOptions();
            opts.assign(mt);
            options.set(MainOptions.HTMLPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.HTML);
        } else if (mt.isText()) {
            opts = new TextOptions();
            opts.assign(mt);
            options.set(MainOptions.TEXTPARSER, (Options)opts);
            options.set(MainOptions.PARSER, (Enum)MainOptions.MainParser.TEXT);
        } else if (!ct.isEmpty() && !mt.isXML()) {
            xml = false;
        }
        String path = conn.dbpath();
        if (path.isEmpty()) {
            session.clear();
            if (xml) {
                session.add((Command)new CreateDB(db), (InputStream)is);
            } else {
                session.add((Command)new CreateDB(db)).add((Command)new Store(db), (InputStream)is);
            }
        } else if (xml) {
            session.add((Command)new Replace(path), (InputStream)is);
        } else {
            session.add((Command)new Delete(path)).add((Command)new Store(path), (InputStream)is);
        }
        return new RESTExec(session, true);
    }
}

