/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.basex.core.Text;
import org.basex.core.parse.Commands;
import org.basex.core.parse.PasswordReader;
import org.basex.util.Prop;
import org.basex.util.Reflect;
import org.basex.util.Util;

public abstract class ConsoleReader
implements AutoCloseable {
    private static final String PW_PROMPT = Text.PASSWORD + ": ";
    private final PasswordReader pwReader = this::readPassword;

    public abstract String readLine(String var1);

    protected abstract String readPassword();

    @Override
    public abstract void close();

    public final PasswordReader pwReader() {
        return this.pwReader;
    }

    public static ConsoleReader get() {
        if (JLineConsoleReader.isAvailable()) {
            try {
                return new JLineConsoleReader();
            }
            catch (Exception ex) {
                Util.errln(ex, new Object[0]);
            }
        }
        return new SimpleConsoleReader();
    }

    private static class JLineConsoleReader
    extends ConsoleReader {
        private static final String JLINE_CONSOLE_READER = "jline.console.ConsoleReader";
        private static final String JLINE_FILE_HISTORY = "jline.console.history.FileHistory";
        private static final String JLINE_HISTORY = "jline.console.history.History";
        private static final String JLINE_COMPLETER = "jline.console.completer.Completer";
        private static final String JLINE_ENUM_COMPLETER = "jline.console.completer.EnumCompleter";
        private static final String JLINE_FILE_NAME_COMPLETER = "jline.console.completer.FileNameCompleter";
        private static final String HISTORY_FILE = ".basexhistory";
        private static final Character PASSWORD_ECHO = Character.valueOf('\u0000');
        private final Method readLine;
        private final Method readEcho;
        private final Object reader;
        private final Class<?> fileHistoryC;
        private final Object fileHistory;

        static boolean isAvailable() {
            return Reflect.available(JLINE_CONSOLE_READER, new Object[0]);
        }

        JLineConsoleReader() throws Exception {
            Class<?> readerC = Reflect.find(JLINE_CONSOLE_READER);
            this.readLine = Reflect.method(readerC, "readLine", String.class);
            this.readEcho = Reflect.method(readerC, "readLine", String.class, Character.class);
            this.reader = readerC.newInstance();
            Class<?> history = Reflect.find(JLINE_HISTORY);
            this.fileHistoryC = Reflect.find(JLINE_FILE_HISTORY);
            this.fileHistory = Reflect.get(Reflect.find(this.fileHistoryC, File.class), new File(Prop.HOMEDIR, HISTORY_FILE));
            Class<?> completer = Reflect.find(JLINE_COMPLETER);
            Class<?> enumCompleter = Reflect.find(JLINE_ENUM_COMPLETER);
            Class<?> fileNameCompleter = Reflect.find(JLINE_FILE_NAME_COMPLETER);
            Reflect.invoke(Reflect.method(readerC, "setBellEnabled", Boolean.TYPE), this.reader, false);
            Reflect.invoke(Reflect.method(readerC, "setHistory", history), this.reader, this.fileHistory);
            Reflect.invoke(Reflect.method(readerC, "setHistoryEnabled", Boolean.TYPE), this.reader, true);
            Reflect.invoke(Reflect.method(readerC, "addCompleter", completer), this.reader, Reflect.get(Reflect.find(enumCompleter, Class.class), Commands.Cmd.class));
            Reflect.invoke(Reflect.method(readerC, "addCompleter", completer), this.reader, Reflect.get(Reflect.find(fileNameCompleter, new Class[0]), new Object[0]));
        }

        @Override
        public String readLine(String prompt) {
            return (String)Reflect.invoke(this.readLine, this.reader, prompt);
        }

        @Override
        public String readPassword() {
            return (String)Reflect.invoke(this.readEcho, this.reader, PW_PROMPT, PASSWORD_ECHO);
        }

        @Override
        public void close() {
            Reflect.invoke(Reflect.method(this.fileHistoryC, "flush", new Class[0]), this.fileHistory, new Object[0]);
        }
    }

    private static class SimpleConsoleReader
    extends ConsoleReader {
        private final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        SimpleConsoleReader() {
        }

        @Override
        public String readLine(String prompt) {
            try {
                Util.out(prompt, new Object[0]);
                return this.in.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String readPassword() {
            Util.out(PW_PROMPT, new Object[0]);
            return Util.password();
        }

        @Override
        public void close() {
        }
    }
}

