/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class MapType
extends FuncType {
    MapType(AtomType type, SeqType declType) {
        super(declType, type.seqType());
    }

    @Override
    public byte[] string() {
        return Token.token("map");
    }

    @Override
    public Map cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        Map m;
        if (item instanceof Map && (m = (Map)item).instanceOf(this)) {
            return m;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof MapType)) {
            return false;
        }
        MapType mt = (MapType)type;
        return this.keyType().eq(mt.keyType()) && this.declType.eq(mt.declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type == AtomType.ITEM || type == SeqType.ANY_MAP || type == SeqType.ANY_FUNC) {
            return true;
        }
        if (!(type instanceof FuncType) || type instanceof ArrayType || this == SeqType.ANY_MAP) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length || !this.declType.instanceOf(ft.declType)) {
            return false;
        }
        if (type instanceof MapType) {
            return this.keyType().instanceOf(((MapType)type).keyType());
        }
        for (int a = 0; a < al; ++a) {
            if (this.argTypes[a].instanceOf(ft.argTypes[a])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            if (mt.instanceOf(this)) {
                return this;
            }
            AtomType at = (AtomType)this.keyType().intersect(mt.keyType());
            return at != null ? MapType.get(at, this.declType.union(mt.declType)) : SeqType.ANY_FUNC;
        }
        return type instanceof ArrayType ? SeqType.ANY_FUNC : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
    }

    @Override
    public MapType intersect(Type type) {
        if (this.instanceOf(type)) {
            return this;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            if (mt.instanceOf(this)) {
                return mt;
            }
            SeqType dt = this.declType.intersect(mt.declType);
            return dt == null ? null : MapType.get((AtomType)this.keyType().union(mt.keyType()), dt);
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            if (ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.AAT_O)) {
                SeqType dt = this.declType.intersect(ft.declType);
                return dt == null ? null : MapType.get((AtomType)this.keyType().union(ft.argTypes[0].type), dt);
            }
        }
        return null;
    }

    public static MapType get(AtomType keyType, SeqType declType) {
        return keyType == AtomType.AAT && declType.eq(SeqType.ITEM_ZM) ? SeqType.ANY_MAP : new MapType(keyType, declType);
    }

    public AtomType keyType() {
        return (AtomType)this.argTypes[0].type;
    }

    @Override
    public String toString() {
        AtomType keyType = this.keyType();
        return keyType == AtomType.AAT && this.declType.eq(SeqType.ITEM_ZM) ? "map(*)" : "map(" + keyType + ", " + this.declType + ')';
    }
}

