/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class StrSeq
extends NativeSeq {
    private final byte[][] values;

    private StrSeq(byte[][] values) {
        super(values.length, (Type)AtomType.STR);
        this.values = values;
    }

    @Override
    public Str itemAt(long pos) {
        return Str.get(this.values[(int)pos]);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof StrSeq ? Array.equals(this.values, ((StrSeq)obj).values) : super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        byte[][] tmp = new byte[sz][];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return StrSeq.get(tmp);
    }

    public String[] toJava() {
        String[] tmp = new String[(int)this.size];
        int v = 0;
        while ((long)v < this.size) {
            tmp[v] = Token.string(this.values[v]);
            ++v;
        }
        return tmp;
    }

    public static Value get(TokenList items) {
        return items.isEmpty() ? Empty.SEQ : (items.size() == 1 ? Str.get((byte[])items.get(0)) : new StrSeq((byte[][])items.finish()));
    }

    public static Value get(byte[][] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Str.get(values[0]) : new StrSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        byte[][] tmp = new byte[size][];
        int t = 0;
        for (Value value : values) {
            int vs = (int)value.size();
            if (value instanceof StrSeq) {
                StrSeq seq = (StrSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = value.itemAt(v).string(null);
            }
        }
        return StrSeq.get(tmp);
    }
}

