/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.io.IOException;
import org.basex.api.dom.BXNode;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.ByteList;

public class DBNode
extends ANode {
    private final Data data;
    private int pre;

    public DBNode(Data data) {
        this(data, 0);
    }

    public DBNode(Data data, int pre) {
        this(data, pre, data.kind(pre));
    }

    public DBNode(Data data, int pre, int kind) {
        this(data, pre, null, DBNode.type(kind));
    }

    DBNode(Data data, int pre, ANode par, NodeType type) {
        super(type);
        this.data = data;
        this.pre = pre;
        this.parent = par;
    }

    public DBNode(IO input) throws IOException {
        this(MemBuilder.build(input));
    }

    public DBNode(Parser parser) throws IOException {
        this(MemBuilder.build("", parser));
    }

    private void set(int p, int k) {
        this.type = DBNode.type(k);
        this.parent = null;
        this.value = null;
        this.pre = p;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    public final void pre(int p) {
        this.pre = p;
    }

    public final int pre() {
        return this.pre;
    }

    @Override
    public final byte[] string() {
        if (this.value == null) {
            this.value = this.data.atom(this.pre);
        }
        return this.value;
    }

    @Override
    public final long itr(InputInfo info) throws QueryException {
        long l;
        if (this.type == NodeType.ELM) {
            long l2;
            int as = this.data.attSize(this.pre, 1);
            if (this.data.size(this.pre, 1) - as == 1 && this.data.kind(this.pre + as) == 2 && (l2 = this.data.textItr(this.pre + as, true)) != Long.MIN_VALUE) {
                return l2;
            }
        } else if ((this.type == NodeType.TXT || this.type == NodeType.ATT) && (l = this.data.textItr(this.pre, this.type == NodeType.TXT)) != Long.MIN_VALUE) {
            return l;
        }
        return Int.parse(this, info);
    }

    @Override
    public final double dbl(InputInfo info) throws QueryException {
        double d = Double.NaN;
        if (this.type == NodeType.ELM) {
            int as = this.data.attSize(this.pre, 1);
            if (this.data.size(this.pre, 1) - as == 1 && this.data.kind(this.pre + as) == 2) {
                d = this.data.textDbl(this.pre + as, true);
            }
        } else if (this.type == NodeType.TXT || this.type == NodeType.ATT) {
            d = this.data.textDbl(this.pre, this.type == NodeType.TXT);
        }
        return Double.isNaN(d) ? Dbl.parse(this, info) : d;
    }

    @Override
    public final byte[] name() {
        return this.type == NodeType.ELM || this.type == NodeType.ATT || this.type == NodeType.PI ? this.data.name(this.pre, DBNode.kind(this.nodeType())) : Token.EMPTY;
    }

    @Override
    public final QNm qname() {
        if (this.type == NodeType.ELM || this.type == NodeType.ATT || this.type == NodeType.PI) {
            byte[][] qname = this.data.qname(this.pre, this.kind());
            return new QNm(qname[0], qname[1]);
        }
        return null;
    }

    @Override
    public final Atts namespaces() {
        return this.data.namespaces(this.pre);
    }

    @Override
    public final byte[] baseURI() {
        if (this.type == NodeType.DOC) {
            String base = Token.string(this.data.text(this.pre, true));
            if (this.data.inMemory()) {
                String path = this.data.meta.original;
                return Token.token(path.isEmpty() ? base : IO.get(path).merge(base).url());
            }
            return new TokenBuilder().add(47).add(this.data.meta.name).add(47).add(base).finish();
        }
        byte[] base = this.attribute(QNm.XML_BASE);
        return base != null ? base : Token.EMPTY;
    }

    @Override
    public final boolean is(ANode node) {
        return node == this || node instanceof DBNode && this.data == node.data() && this.pre == ((DBNode)node).pre;
    }

    @Override
    public final int diff(ANode node) {
        if (node instanceof FNode) {
            return -DBNode.diff(node, this);
        }
        Data ndata = node.data();
        return this.data == ndata ? this.pre - ((DBNode)node).pre : this.data.compareTo(ndata);
    }

    @Override
    public final Value copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.finish();
    }

    @Override
    public final DBNode dbNodeCopy(MainOptions opts, QueryContext qc) {
        MemData md = new MemData(opts);
        new DataBuilder(md, qc).build(this);
        return new DBNode(md).parent(this.parent);
    }

    @Override
    public final DBNode deepCopy(MainOptions options, QueryContext qc) {
        return this.dbNodeCopy(options, qc);
    }

    @Override
    public final DBNode finish() {
        DBNode n = new DBNode(this.data, this.pre, this.parent, this.nodeType());
        n.score = this.score;
        return n;
    }

    @Override
    public final ANode parent() {
        if (this.parent != null) {
            return this.parent;
        }
        int p = this.data.parent(this.pre, this.data.kind(this.pre));
        if (p == -1) {
            return null;
        }
        DBNode node = this.finish();
        node.set(p, this.data.kind(p));
        return node;
    }

    @Override
    protected final DBNode parent(ANode par) {
        this.parent = par;
        return this;
    }

    @Override
    public final boolean hasChildren() {
        int kind = this.data.kind(this.pre);
        return this.data.attSize(this.pre, kind) != this.data.size(this.pre, kind);
    }

    @Override
    public final DBNodeIter ancestor() {
        return new DBNodeIter(this.data){
            private final DBNode node;
            int curr;
            int kind;
            {
                this.node = DBNode.this.finish();
                this.curr = DBNode.this.pre;
                this.kind = this.data.kind(this.curr);
            }

            @Override
            public DBNode next() {
                this.curr = this.data.parent(this.curr, this.kind);
                if (this.curr == -1) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter ancestorOrSelf() {
        return new DBNodeIter(this.data){
            private final DBNode node;
            int curr;
            int kind;
            {
                this.node = DBNode.this.finish();
                this.curr = DBNode.this.pre;
                this.kind = this.data.kind(this.curr);
            }

            @Override
            public DBNode next() {
                if (this.curr == -1) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr = this.data.parent(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter attributes() {
        return new DBNodeIter(this.data){
            final DBNode node;
            final int size;
            int curr;
            {
                this.node = DBNode.this.finish();
                this.size = this.data.attSize(DBNode.this.pre, this.data.kind(DBNode.this.pre));
                this.curr = DBNode.this.pre + 1;
            }

            @Override
            public DBNode next() {
                if (this.curr == DBNode.this.pre + this.size) {
                    return null;
                }
                DBNode n = this.node;
                n.set(this.curr++, 3);
                return n;
            }

            @Override
            public ANode get(long i) {
                DBNode n = this.node;
                n.set(DBNode.this.pre + 1 + (int)i, 3);
                return n;
            }

            @Override
            public long size() {
                return this.size - 1;
            }
        };
    }

    @Override
    public final DBNodeIter children() {
        return new DBNodeIter(this.data){
            int kind;
            int curr;
            final int last;
            final DBNode node;
            {
                this.kind = this.data.kind(DBNode.this.pre);
                this.curr = DBNode.this.pre + this.data.attSize(DBNode.this.pre, this.kind);
                this.last = DBNode.this.pre + this.data.size(DBNode.this.pre, this.kind);
                this.node = DBNode.this.finish();
            }

            @Override
            public DBNode next() {
                if (this.curr == this.last) {
                    return null;
                }
                Data d = this.data;
                this.kind = d.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr += d.size(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter descendant() {
        return new DBNodeIter(this.data){
            int kind;
            int curr;
            final int last;
            final DBNode node;
            {
                this.kind = this.data.kind(DBNode.this.pre);
                this.curr = DBNode.this.pre + this.data.attSize(DBNode.this.pre, this.kind);
                this.last = DBNode.this.pre + this.data.size(DBNode.this.pre, this.kind);
                this.node = DBNode.this.finish();
            }

            @Override
            public DBNode next() {
                if (this.curr == this.last) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr += this.data.attSize(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter descendantOrSelf() {
        return new DBNodeIter(this.data){
            final DBNode node;
            final int last;
            int curr;
            {
                this.node = DBNode.this.finish();
                this.last = DBNode.this.pre + this.data.size(DBNode.this.pre, this.data.kind(DBNode.this.pre));
                this.curr = DBNode.this.pre;
            }

            @Override
            public DBNode next() {
                if (this.curr == this.last) {
                    return null;
                }
                int k = this.data.kind(this.curr);
                this.node.set(this.curr, k);
                this.curr += this.data.attSize(this.curr, k);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter following() {
        return new DBNodeIter(this.data){
            private final DBNode node;
            int kind;
            int curr;
            int size;
            {
                this.node = DBNode.this.finish();
                this.kind = this.data.kind(DBNode.this.pre);
                this.curr = DBNode.this.pre + this.data.size(DBNode.this.pre, this.kind);
                this.size = -1;
            }

            @Override
            public DBNode next() {
                if (this.size == -1) {
                    if (this.data.meta.ndocs > 1) {
                        int p = DBNode.this.pre;
                        for (ANode n : DBNode.this.ancestor()) {
                            p = ((DBNode)n).pre;
                        }
                        this.size = p + this.data.size(p, this.data.kind(p));
                    } else {
                        this.size = this.data.meta.size;
                    }
                }
                if (this.curr == this.size) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr += this.data.attSize(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final DBNodeIter followingSibling() {
        return new DBNodeIter(this.data){
            private final DBNode node;
            int kind;
            private final int pp;
            final int sz;
            int curr;
            {
                this.node = DBNode.this.finish();
                this.kind = this.data.kind(DBNode.this.pre);
                this.pp = this.data.parent(DBNode.this.pre, this.kind);
                this.sz = this.pp == -1 ? 0 : this.pp + this.data.size(this.pp, this.data.kind(this.pp));
                this.curr = this.pp == -1 ? 0 : DBNode.this.pre + this.data.size(DBNode.this.pre, this.kind);
            }

            @Override
            public DBNode next() {
                if (this.curr == this.sz) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr += this.data.size(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof DBNode && this.is((DBNode)obj);
    }

    @Override
    public final void plan(FElem plan) {
        DBNode.addPlan(plan, this.planElem("database", this.data.meta.name, "pre", this.pre, "type", this.type), new ExprInfo[0]);
    }

    @Override
    public final byte[] xdmInfo() {
        ByteList bl = new ByteList().add(this.typeId().asByte());
        if (this.type == NodeType.DOC) {
            bl.add(this.baseURI()).add(0);
        } else if (this.type == NodeType.ATT) {
            bl.add(this.qname().uri()).add(0);
        }
        return bl.finish();
    }

    @Override
    public final Type.ID typeId() {
        DBNodeIter iter;
        DBNode n;
        Type.ID i = this.type.id();
        if (this.type == NodeType.DOC && (n = (iter = this.children()).next()) != null && n.type == NodeType.ELM && iter.next() == null) {
            i = NodeType.DEL.id();
        }
        return i;
    }

    @Override
    public String toErrorString() {
        return this.toString(false);
    }

    @Override
    public String toString() {
        return this.toString(!this.data.inMemory());
    }

    private String toString(boolean func) {
        if (func) {
            return Function._DB_OPEN_PRE.args(this.data.meta.name, this.pre).substring(1);
        }
        TokenBuilder tb = new TokenBuilder(this.type.string()).add(32);
        switch ((NodeType)this.type) {
            case ATT: 
            case PI: {
                tb.add(this.name()).add(" {\"").add(Token.chop(this.string(), 32)).add("\"}");
                break;
            }
            case ELM: {
                tb.add(this.name()).add(" {");
                if (this.hasChildren() || this.attributes().size() != 0L) {
                    tb.add("...");
                }
                tb.add(125);
                break;
            }
            case DOC: {
                tb.add("{\"").add(this.data.text(this.pre, true)).add("\"}");
                break;
            }
            default: {
                tb.add("{\"").add(Token.chop(this.string(), 32)).add("\"}");
            }
        }
        return tb.toString();
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this.deepCopy(new MainOptions(), null));
    }
}

