/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.Arrays;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.Value;
import org.basex.query.value.array.PartialLeafNode;
import org.basex.util.Util;

final class LeafNode
implements Node<Value, Value> {
    final Value[] values;

    LeafNode(Value[] values) {
        this.values = values;
        assert (values.length >= 8 && values.length <= 15);
    }

    @Override
    public long size() {
        return this.values.length;
    }

    public LeafNode reverse() {
        int n = this.values.length;
        Value[] out = new Value[n];
        for (int i = 0; i < n; ++i) {
            out[i] = this.values[n - 1 - i];
        }
        return new LeafNode(out);
    }

    public LeafNode set(long pos, Value val) {
        Value[] vals = (Value[])this.values.clone();
        vals[(int)pos] = val;
        return new LeafNode(vals);
    }

    @Override
    public boolean insert(Node<Value, Value>[] siblings, long pos, Value val) {
        int p = (int)pos;
        int n = this.values.length;
        Value[] vals = new Value[n + 1];
        System.arraycopy(this.values, 0, vals, 0, p);
        vals[p] = val;
        System.arraycopy(this.values, p, vals, p + 1, n - p);
        if (n < 15) {
            siblings[1] = new LeafNode(vals);
            return false;
        }
        LeafNode left = (LeafNode)siblings[0];
        if (left != null && left.values.length < 15) {
            Value[] lvals = left.values;
            int l = lvals.length;
            int diff = 15 - l;
            int move = (diff + 1) / 2;
            Value[] newLeft = new Value[l + move];
            Value[] newRight = new Value[n + 1 - move];
            System.arraycopy(lvals, 0, newLeft, 0, l);
            System.arraycopy(vals, 0, newLeft, l, move);
            System.arraycopy(vals, move, newRight, 0, newRight.length);
            siblings[0] = new LeafNode(newLeft);
            siblings[1] = new LeafNode(newRight);
            return false;
        }
        LeafNode right = (LeafNode)siblings[2];
        if (right != null && right.values.length < 15) {
            Value[] rvals = right.values;
            int r = rvals.length;
            int diff = 15 - r;
            int move = (diff + 1) / 2;
            int l = n + 1 - move;
            Value[] newLeft = new Value[l];
            Value[] newRight = new Value[r + move];
            System.arraycopy(vals, 0, newLeft, 0, l);
            System.arraycopy(vals, l, newRight, 0, move);
            System.arraycopy(rvals, 0, newRight, move, r);
            siblings[1] = new LeafNode(newLeft);
            siblings[2] = new LeafNode(newRight);
            return false;
        }
        int l = vals.length / 2;
        int r = vals.length - l;
        Value[] newLeft = new Value[l];
        Value[] newRight = new Value[r];
        System.arraycopy(vals, 0, newLeft, 0, l);
        System.arraycopy(vals, l, newRight, 0, r);
        siblings[3] = siblings[2];
        siblings[1] = new LeafNode(newLeft);
        siblings[2] = new LeafNode(newRight);
        return true;
    }

    @Override
    public NodeLike<Value, Value>[] remove(Node<Value, Value> left, Node<Value, Value> right, long pos) {
        int p = (int)pos;
        int n = this.values.length;
        NodeLike[] out = new NodeLike[]{left, null, right};
        if (n > 8) {
            Value[] vals = new Value[n - 1];
            System.arraycopy(this.values, 0, vals, 0, p);
            System.arraycopy(this.values, p + 1, vals, p, n - 1 - p);
            out[1] = new LeafNode(vals);
            return out;
        }
        LeafNode leftLeaf = (LeafNode)left;
        if (leftLeaf != null && leftLeaf.arity() > 8) {
            Value[] lvals = leftLeaf.values;
            int l = lvals.length;
            int diff = l - 8;
            int move = (diff + 1) / 2;
            int ll = l - move;
            int rl = n - 1 + move;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            System.arraycopy(lvals, 0, newLeft, 0, ll);
            System.arraycopy(lvals, ll, newRight, 0, move);
            System.arraycopy(this.values, 0, newRight, move, p);
            System.arraycopy(this.values, p + 1, newRight, move + p, n - 1 - p);
            out[0] = new LeafNode(newLeft);
            out[1] = new LeafNode(newRight);
            return out;
        }
        LeafNode rightLeaf = (LeafNode)right;
        if (rightLeaf != null && rightLeaf.arity() > 8) {
            Value[] rvals = rightLeaf.values;
            int r = rvals.length;
            int diff = r - 8;
            int move = (diff + 1) / 2;
            int ll = n - 1 + move;
            int rl = r - move;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            System.arraycopy(this.values, 0, newLeft, 0, p);
            System.arraycopy(this.values, p + 1, newLeft, p, n - 1 - p);
            System.arraycopy(rvals, 0, newLeft, n - 1, move);
            System.arraycopy(rvals, move, newRight, 0, rl);
            out[1] = new LeafNode(newLeft);
            out[2] = new LeafNode(newRight);
            return out;
        }
        if (left != null) {
            Value[] lvals = ((LeafNode)left).values;
            int l = lvals.length;
            int r = this.values.length;
            Value[] vals = new Value[l + r - 1];
            System.arraycopy(lvals, 0, vals, 0, l);
            System.arraycopy(this.values, 0, vals, l, p);
            System.arraycopy(this.values, p + 1, vals, l + p, r - 1 - p);
            out[0] = new LeafNode(vals);
            out[1] = null;
            return out;
        }
        if (right != null) {
            Value[] rvals = ((LeafNode)right).values;
            int l = this.values.length;
            int r = rvals.length;
            Value[] vals = new Value[l - 1 + r];
            System.arraycopy(this.values, 0, vals, 0, p);
            System.arraycopy(this.values, p + 1, vals, p, l - 1 - p);
            System.arraycopy(rvals, 0, vals, l - 1, r);
            out[1] = null;
            out[2] = new LeafNode(vals);
            return out;
        }
        Value[] vals = new Value[n - 1];
        System.arraycopy(this.values, 0, vals, 0, p);
        System.arraycopy(this.values, p + 1, vals, p, n - 1 - p);
        out[1] = new PartialLeafNode(vals);
        return out;
    }

    @Override
    public int append(NodeLike<Value, Value>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Value, Value> left = nodes[pos - 1];
        if (!(left instanceof PartialLeafNode)) {
            nodes[pos] = this;
            return pos + 1;
        }
        Value[] ls = ((PartialLeafNode)left).elems;
        int l = ls.length;
        Value[] rs = this.values;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Value[] vals = new Value[n];
            System.arraycopy(ls, 0, vals, 0, l);
            System.arraycopy(rs, 0, vals, l, r);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = r - rl;
        Value[] newLeft = new Value[ll];
        Value[] newRight = new Value[rl];
        System.arraycopy(ls, 0, newLeft, 0, l);
        System.arraycopy(rs, 0, newLeft, l, move);
        System.arraycopy(rs, move, newRight, 0, rl);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    @Override
    public NodeLike<Value, Value> slice(long off, long size) {
        int p = (int)off;
        int n = (int)size;
        Value[] out = new Value[n];
        System.arraycopy(this.values, p, out, 0, n);
        return n < 8 ? new PartialLeafNode(out) : new LeafNode(out);
    }

    @Override
    public long checkInvariants() {
        if (this.values.length < 8 || this.values.length > 15) {
            throw new AssertionError((Object)("Wrong " + Util.className(this) + " size: " + this.values.length));
        }
        return this.values.length;
    }

    @Override
    public int arity() {
        return this.values.length;
    }

    @Override
    public Value getSub(int index) {
        return this.values[index];
    }

    public String toString() {
        return Util.className(this) + '(' + this.size() + ')' + Arrays.toString(this.values);
    }
}

