/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.Constr;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.ReplaceNode;
import org.basex.query.up.primitives.node.ReplaceValue;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Replace
extends Update {
    private final boolean value;

    public Replace(StaticContext sc, InputInfo info, Expr trg, Expr src, boolean value) {
        super(sc, info, trg, src);
        this.value = value;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Constr c = new Constr(this.info, this.sc).add(qc, this.exprs[1]);
        if (c.errAtt != null) {
            throw QueryError.UPNOATTRPER_X.get(this.info, c.errAtt);
        }
        if (c.duplAtt != null) {
            throw QueryError.UPATTDUPL_X.get(this.info, c.duplAtt);
        }
        Iter iter = this.exprs[0].iter(qc);
        Item item = iter.next();
        if (item == null) {
            throw QueryError.UPSEQEMP_X.get(this.info, Util.className(this));
        }
        Type type = item.type;
        if (!(item instanceof ANode) || type == NodeType.DOC) {
            throw QueryError.UPTRGNODE_X.get(this.info, item);
        }
        Item item2 = iter.next();
        if (item2 != null) {
            throw QueryError.UPTRGSINGLE_X.get(this.info, ValueBuilder.concat(item, item2, qc));
        }
        ANode targ = (ANode)item;
        Updates updates = qc.updates();
        DBNode dbn = updates.determineDataRef(targ, qc);
        ANodeList aList = c.atts;
        ANodeList list = c.children;
        if (this.value) {
            byte[] txt;
            byte[] byArray = list.size() < 1 ? (aList.size() < 1 ? Token.EMPTY : ((ANode)aList.get(0)).string()) : (txt = ((ANode)list.get(0)).string());
            if (type == NodeType.COM) {
                FComm.parse(txt, this.info);
            }
            if (type == NodeType.PI) {
                FPI.parse(txt, this.info);
            }
            updates.add(new ReplaceValue(dbn.pre(), dbn.data(), this.info, txt), qc);
        } else {
            ANode par = targ.parent();
            if (par == null) {
                throw QueryError.UPNOPAR_X.get(this.info, targ);
            }
            if (type == NodeType.ATT) {
                if (!list.isEmpty()) {
                    throw QueryError.UPWRATTR_X.get(this.info, list.get(0));
                }
                list = this.checkNS(aList, par);
            } else if (!aList.isEmpty()) {
                throw QueryError.UPWRELM_X.get(this.info, targ);
            }
            updates.add(new ReplaceNode(dbn.pre(), dbn.data(), this.info, list), qc);
        }
        return null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Replace(this.sc, this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Replace && this.value == ((Replace)obj).value && super.equals(obj);
    }

    @Override
    public String toString() {
        return "replace" + (this.value ? " value of" : "") + ' ' + "node" + ' ' + this.exprs[0] + ' ' + "with" + ' ' + this.exprs[1];
    }
}

