/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.io.IOFile;
import org.basex.io.random.DataAccess;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.B64Lazy;

public final class FileReadBinary
extends FileFn {
    @Override
    public B64 item(QueryContext qc) throws QueryException, IOException {
        long len;
        Path path = this.toPath(0, qc);
        long off = this.exprs.length > 1 ? this.toLong(this.exprs[1], qc) : 0L;
        long l = len = this.exprs.length > 2 ? this.toLong(this.exprs[2], qc) : 0L;
        if (!Files.exists(path, new LinkOption[0])) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, path.toAbsolutePath());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        if (this.exprs.length == 1) {
            return new B64Lazy(new IOFile(path.toFile()), QueryError.FILE_IO_ERROR_X);
        }
        try (DataAccess da = new DataAccess(new IOFile(path.toFile()));){
            long dlen = da.length();
            if (this.exprs.length == 2) {
                len = dlen - off;
            }
            if (off < 0L || off > dlen || len < 0L || off + len > dlen) {
                throw QueryError.FILE_OUT_OF_RANGE_X_X.get(this.info, off, off + len);
            }
            da.cursor(off);
            B64 b64 = B64.get(da.readBytes((int)len));
            return b64;
        }
    }
}

