/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;

public abstract class Preds
extends Arr {
    protected Preds(InputInfo info, SeqType seqType, Expr ... exprs) {
        super(info, seqType, exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        QueryFocus focus = cc.qc.focus;
        Value init = focus.value;
        int pl = this.exprs.length;
        for (int p = 0; p < pl; ++p) {
            try {
                this.exprs[p] = this.exprs[p].compile(cc);
                continue;
            }
            catch (QueryException ex) {
                this.exprs[p] = cc.error(ex, this);
            }
        }
        focus.value = init;
        return this;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int es = this.exprs.length;
        ExprList list = new ExprList(es);
        boolean pos = false;
        for (int e = 0; e < es; ++e) {
            Expr expr = this.exprs[e].optimizeEbv(cc);
            if (expr instanceof CmpG || expr instanceof CmpV) {
                Cmp cmp = (Cmp)expr;
                Expr cmp1 = cmp.exprs[0];
                Expr cmp2 = cmp.exprs[1];
                if (cmp1.isFunction(Function.POSITION) && Preds.numeric(cmp2) && (cmp instanceof CmpG && ((CmpG)cmp).op == CmpG.OpG.EQ || cmp instanceof CmpV && ((CmpV)cmp).op == CmpV.OpV.EQ)) {
                    expr = cc.replaceWith(expr, cmp2);
                }
            } else if (expr instanceof And) {
                if (!expr.has(Flag.POS)) {
                    cc.info("rewrite % to predicate(s)", expr);
                    Expr[] ands = ((Arr)expr).exprs;
                    int m = ands.length;
                    for (int a = 0; a < m; ++a) {
                        expr = ands[a];
                        if (expr.seqType().mayBeNumber()) {
                            expr = cc.function(Function.BOOLEAN, this.info, expr);
                        }
                        if (a + 1 >= m) continue;
                        pos = this.add(expr, list, pos, cc);
                    }
                }
            } else if (expr instanceof ANum) {
                ANum it = (ANum)expr;
                long l = it.itr();
                if ((double)l != it.dbl()) {
                    return cc.emptySeq(this);
                }
                expr = ItrPos.get(l, this.info);
                if (!(expr instanceof ItrPos)) {
                    return cc.emptySeq(this);
                }
            } else if (expr instanceof Value) {
                expr = Bln.get(expr.ebv(cc.qc, this.info).bool(this.info));
            }
            if (expr == Bln.FALSE) {
                return cc.emptySeq(this);
            }
            if (this.exprs[e] != expr) {
                cc.replaceWith(this.exprs[e], expr);
            }
            pos = this.add(expr, list, pos, cc);
        }
        this.exprs = (Expr[])list.finish();
        return this;
    }

    private boolean add(Expr expr, ExprList list, boolean pos, CompileContext cc) {
        boolean ps;
        boolean bl = ps = pos || expr.seqType().mayBeNumber() || expr.has(Flag.POS);
        if (expr == Bln.TRUE) {
            cc.info("remove % from %", expr, this.description());
        } else if (ps || !list.contains(expr) || expr.has(Flag.NDT)) {
            list.add(expr);
        }
        return ps;
    }

    protected final boolean exprType(SeqType seqType, long size) {
        boolean exact = size != -1L;
        long max = exact ? size : Long.MAX_VALUE;
        for (Expr expr : this.exprs) {
            if (expr.isFunction(Function.LAST)) {
                max = Math.min(max, 1L);
                continue;
            }
            if (expr instanceof ItrPos) {
                ItrPos pos = (ItrPos)expr;
                if (max != Long.MAX_VALUE) {
                    max = Math.max(0L, max - pos.min + 1L);
                }
                max = Math.min(max, pos.max - pos.min + 1L);
                continue;
            }
            exact = false;
        }
        Occ occ = max == 1L ? Occ.ZERO_ONE : Occ.ZERO_MORE;
        long sz = exact || max == 0L ? max : -1L;
        this.exprType.assign(seqType.type, occ, sz);
        return max != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean preds(Item item, QueryContext qc) throws QueryException {
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        qf.value = item;
        try {
            double s = qc.scoring ? 0.0 : -1.0;
            for (Expr expr : this.exprs) {
                Item test = expr.test(qc, this.info);
                if (test == null) {
                    boolean bl = false;
                    return bl;
                }
                if (s == -1.0) continue;
                s += test.score();
            }
            if (s > 0.0) {
                item.score(Scoring.avg(s, this.exprs.length));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            qf.value = cv;
        }
    }

    public final void simplify(CompileContext cc, Expr root) {
        ExprList list = new ExprList();
        SeqType st = root.seqType();
        for (Expr expr : this.exprs) {
            Expr first;
            Expr ex = expr;
            if (ex instanceof ContextValue && st.instanceOf(SeqType.NOD_ZM)) {
                cc.info("remove % from %", ex, this.description());
                continue;
            }
            if (ex instanceof SimpleMap) {
                SimpleMap map = (SimpleMap)ex;
                first = map.exprs[0];
                Expr second = map.exprs[1];
                if (!second.has(Flag.POS) && (first instanceof ContextValue || root.equals(first) && root.isSimple() && st.one())) {
                    int ml = map.exprs.length;
                    ExprList el = new ExprList(ml - 1);
                    for (int m = 1; m < ml; ++m) {
                        el.add(map.exprs[m]);
                    }
                    ex = SimpleMap.get(map.info, (Expr[])el.finish());
                }
            } else if (ex instanceof Path) {
                Path path = (Path)ex;
                first = path.root;
                if (st.type instanceof NodeType && (first instanceof ContextValue || root.equals(first) && root.isSimple() && st.one())) {
                    ex = Path.get(path.info, null, path.steps);
                }
            }
            list.add(cc.replaceWith(expr, ex));
        }
        this.exprs = (Expr[])list.finish();
    }

    public final Expr optimizeEbv(Expr root, CompileContext cc) throws QueryException {
        Expr expr1;
        ParseExpr cmp;
        if (this.exprs.length != 1 || !(root.seqType().type instanceof NodeType)) {
            return this;
        }
        Expr pred = this.exprs[0];
        if (pred.seqType().mayBeNumber()) {
            return this;
        }
        if (pred instanceof Path) {
            return Path.get(this.info, root, pred).optimize(cc);
        }
        if (pred instanceof CmpG) {
            cmp = (CmpG)pred;
            Expr expr = cmp.exprs[0];
            Expr expr2 = cmp.exprs[1];
            if (!expr2.has(Flag.CTX)) {
                expr1 = null;
                if (expr instanceof ContextValue) {
                    expr1 = root;
                }
                if (expr instanceof Path) {
                    expr1 = Path.get(this.info, root, expr).optimize(cc);
                }
                if (expr1 != null) {
                    return new CmpG(expr1, expr2, cmp.op, cmp.coll, cmp.sc, cmp.info);
                }
            }
        }
        if (pred instanceof FTContains) {
            cmp = (FTContains)pred;
            FTExpr ftexpr = ((FTContains)cmp).ftexpr;
            if (!ftexpr.has(Flag.CTX)) {
                Expr expr = ((FTContains)cmp).expr;
                expr1 = null;
                if (expr instanceof ContextValue) {
                    expr1 = root;
                }
                if (expr instanceof Path) {
                    expr1 = Path.get(this.info, root, expr).optimize(cc);
                }
                if (expr1 != null) {
                    return new FTContains(expr1, ftexpr, ((FTContains)cmp).info);
                }
            }
        }
        return this;
    }

    protected static boolean numeric(Expr expr) {
        SeqType st = expr.seqType();
        return st.type.isNumber() && st.zeroOrOne() && expr.isSimple();
    }

    public boolean positional() {
        return Preds.positional(this.exprs);
    }

    public static boolean positional(Expr[] exprs) {
        for (Expr expr : exprs) {
            if (!expr.seqType().mayBeNumber() && !expr.has(Flag.POS)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var var) {
        for (Expr expr : this.exprs) {
            if (!expr.uses(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expr expr : this.exprs) {
            sb.append('[').append(expr).append(']');
        }
        return sb.toString();
    }
}

