/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Arith
extends Arr {
    private final Calc calc;

    public Arith(InputInfo info, Expr expr1, Expr expr2, Calc calc) {
        super(info, SeqType.AAT_ZO, expr1, expr2);
        this.calc = calc;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr ex;
        boolean nums;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Type type1 = st1.type;
        Type type2 = st2.type;
        boolean bl = nums = type1.isNumberOrUntyped() && type2.isNumberOrUntyped();
        AtomType type = this.calc == Calc.IDIV ? AtomType.ITR : (nums ? Calc.type(type1, type2) : AtomType.AAT);
        boolean oneNoArray = st1.oneNoArray() && st2.oneNoArray();
        this.exprType.assign((Type)type, oneNoArray ? Occ.ONE : Occ.ZERO_ONE);
        Expr expr = this;
        if (this.oneIsEmpty()) {
            expr = cc.emptySeq(this);
        } else if (this.allAreValues(false)) {
            expr = this.value(cc.qc);
        } else if (nums && oneNoArray && (ex = this.calc.optimize(expr1, expr2)) != null && ex.seqType().type.eq(type)) {
            expr = ex;
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == null) {
            return null;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        return item2 == null ? null : this.calc.eval(item1, item2, this.info);
    }

    @Override
    public Arith copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Arith(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.calc));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Arith && this.calc == ((Arith)obj).calc && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Arith.addPlan(plan, this.planElem("op", this.calc.name), this.exprs);
    }

    @Override
    public String description() {
        return '\'' + this.calc.name + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(' ' + this.calc.name + ' ');
    }
}

