/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import java.util.Stack;
import org.basex.data.Data;
import org.basex.index.path.PathIndex;
import org.basex.index.path.PathNode;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.Test;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class QuerySuggest
extends QueryParser {
    private final Data data;
    private Stack<ArrayList<PathNode>> stack;
    private ArrayList<PathNode> all;
    private ArrayList<PathNode> curr;
    private boolean show;
    private byte[] name;

    public QuerySuggest(String query, QueryContext qc, Data data) throws QueryException {
        super(query, null, qc, null);
        this.data = data;
        this.checkInit();
    }

    public StringList complete() {
        StringList sl = new StringList();
        if (this.show) {
            for (PathNode n : this.curr) {
                String nm = Token.string(n.token(this.data));
                if (nm.isEmpty() || sl.contains(nm)) continue;
                sl.add(nm);
            }
            sl.sort();
        }
        return sl;
    }

    @Override
    void checkInit() {
        if (this.stack != null && !this.stack.empty()) {
            return;
        }
        this.all = this.data.paths.root();
        this.curr = this.all;
        this.stack = new Stack();
    }

    @Override
    void checkAxis(Axis axis) {
        this.all = axis != Axis.CHILD && axis != Axis.DESC ? new ArrayList() : PathIndex.desc(this.curr, axis == Axis.DESC);
        this.curr = this.all;
        this.show = true;
    }

    @Override
    protected void checkTest(Test test, boolean attr) {
        TokenBuilder tb = new TokenBuilder();
        if (attr) {
            tb.add(64);
        }
        if (test != null) {
            tb.add(test.toString().replaceAll("\\*:", ""));
        }
        this.name = tb.finish();
        this.checkTest(this.pos < this.length);
    }

    private void checkTest(boolean eq) {
        if (this.name == null) {
            return;
        }
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        boolean s = false;
        for (PathNode p : this.all) {
            byte[] nm = p.token(this.data);
            if (!Token.startsWith(nm, this.name)) continue;
            if (!eq || Token.eq(nm, this.name)) {
                tmp.add(p);
            }
            s |= !Token.eq(this.name, nm);
        }
        this.show = this.name.length == 0 || s;
        this.curr = tmp;
    }

    @Override
    protected void checkPred(boolean open) {
        if (this.stack == null) {
            return;
        }
        if (open) {
            this.checkTest(true);
            this.stack.add(new ArrayList<PathNode>(this.curr));
            this.checkAxis(Axis.CHILD);
        } else {
            this.curr = this.stack.pop();
            this.show = false;
            this.all = this.curr;
        }
    }

    @Override
    public QueryException error(QueryError err, InputInfo info, Object ... arg) {
        return err.get(info, arg).suggest(this, this.complete());
    }
}

