/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogEditorPrefs;
import org.basex.gui.dialog.DialogGeneralPrefs;
import org.basex.gui.dialog.DialogVisualPrefs;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXTabs;

public final class DialogPrefs
extends BaseXDialog {
    private static DialogPrefs dialog;
    private final DialogGeneralPrefs general;
    private final DialogEditorPrefs editor;
    private final DialogVisualPrefs visual;
    private final BaseXTabs tabs = new BaseXTabs(this);

    private DialogPrefs(GUI gui) {
        super(gui, Text.PREFERENCES, false);
        this.general = new DialogGeneralPrefs(this);
        this.editor = new DialogEditorPrefs(this);
        this.visual = new DialogVisualPrefs(this);
        this.tabs.add(Text.GENERAL, this.general);
        this.tabs.add(Text.EDITOR, this.editor);
        this.tabs.add(Text.VISUALIZATION, this.visual);
        this.tabs.setSelectedIndex(gui.gopts.get(GUIOptions.PREFTAB));
        this.set(this.tabs, "Center");
        this.action(null);
        this.finish();
    }

    public static void show(GUI gui) {
        if (dialog == null) {
            dialog = new DialogPrefs(gui);
        }
        DialogPrefs.dialog.visual.update();
        dialog.setVisible(true);
    }

    @Override
    public void action(Object cmp) {
        this.ok = this.general.action(cmp) & this.editor.action() & this.visual.action();
        this.gui.notify.layout();
    }

    @Override
    public void close() {
        if (this.ok) {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.visual.cancel();
        this.gui.gopts.set(GUIOptions.PREFTAB, this.tabs.getSelectedIndex());
        super.close();
    }
}

