/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.data.DataClip;
import org.basex.data.DataPrinter;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.data.NSScope;
import org.basex.data.Namespaces;
import org.basex.index.IdPreMap;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.path.PathIndex;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.resource.Resources;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.io.IOFile;
import org.basex.io.random.TableAccess;
import org.basex.query.util.IndexCosts;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public abstract class Data
implements Comparable<Data> {
    public static final byte DOC = 0;
    public static final byte ELEM = 1;
    public static final byte TEXT = 2;
    public static final byte ATTR = 3;
    public static final byte COMM = 4;
    public static final byte PI = 5;
    public final Resources resources = new Resources(this);
    public final MetaData meta;
    public Names elemNames;
    public Names attrNames;
    public Namespaces nspaces;
    public PathIndex paths;
    public ValueIndex textIndex;
    public ValueIndex attrIndex;
    public ValueIndex tokenIndex;
    public ValueIndex ftIndex;
    public boolean updateDists = true;
    public IdPreMap idmap;
    protected TableAccess table;
    protected boolean closed;
    private byte[] b = new byte[16];
    private int bp;

    protected Data(MetaData meta) {
        this.meta = meta;
    }

    public void close() {
        this.closed = true;
    }

    public final boolean closed() {
        return this.closed;
    }

    public abstract void createIndex(IndexType var1, Command var2) throws IOException;

    public abstract void dropIndex(IndexType var1) throws BaseXException;

    public abstract void startUpdate(MainOptions var1) throws BaseXException;

    public abstract void finishUpdate(MainOptions var1);

    public abstract void flush(boolean var1);

    public final IndexIterator iter(IndexToken token) {
        return this.index(token.type()).iter(token);
    }

    public final IndexCosts costs(IndexToken token) {
        return this.index(token.type()).costs(token);
    }

    public final byte[] info(IndexType type, MainOptions options) {
        return this.index(type).info(options);
    }

    public final Index index(IndexType type) {
        switch (type) {
            case ELEMNAME: {
                return this.elemNames;
            }
            case ATTRNAME: {
                return this.attrNames;
            }
            case TEXT: {
                return this.textIndex;
            }
            case ATTRIBUTE: {
                return this.attrIndex;
            }
            case TOKEN: {
                return this.tokenIndex;
            }
            case FULLTEXT: {
                return this.ftIndex;
            }
            case PATH: {
                return this.paths;
            }
        }
        throw Util.notExpected();
    }

    public final byte[] atom(int pre) {
        int k;
        int p;
        switch (this.kind(pre)) {
            case 2: 
            case 4: {
                return this.text(pre, true);
            }
            case 3: {
                return this.text(pre, false);
            }
            case 5: {
                byte[] txt = this.text(pre, true);
                int i = Token.indexOf(txt, 32);
                return i == -1 ? Token.EMPTY : Token.substring(txt, i + 1);
            }
        }
        TokenBuilder tb = null;
        byte[] t = Token.EMPTY;
        int s = p + this.size(p, this.kind(p));
        for (p = pre; p < s; p += this.attSize(p, k)) {
            k = this.kind(p);
            if (k != 2) continue;
            byte[] txt = this.text(p, true);
            if (t == Token.EMPTY) {
                t = txt;
                continue;
            }
            if (tb == null) {
                tb = new TokenBuilder(t);
            }
            tb.add(txt);
        }
        return tb == null ? t : tb.finish();
    }

    public final int pre(int id) {
        if (this.meta.updindex) {
            return this.idmap.pre(id);
        }
        int size = this.meta.size;
        for (int p = Math.max(0, id); p < this.meta.size; ++p) {
            if (id != this.id(p)) continue;
            return p;
        }
        int ps = Math.min(size, id);
        for (int p = 0; p < ps; ++p) {
            if (id != this.id(p)) continue;
            return p;
        }
        return -1;
    }

    public final int id(int pre) {
        return this.table.read4(pre, 12);
    }

    public final int kind(int pre) {
        return this.table.read1(pre, 0) & 7;
    }

    public final int parent(int pre, int kind) {
        return pre - this.dist(pre, kind);
    }

    public final int dist(int pre, int kind) {
        switch (kind) {
            case 1: {
                return this.table.read4(pre, 4);
            }
            case 2: 
            case 4: 
            case 5: {
                return this.table.read4(pre, 8);
            }
            case 3: {
                int d;
                if (d >= 31) {
                    for (d = this.table.read1(pre, 0) >> 3 & 0x1F; d < pre && this.kind(pre - d) == 3; ++d) {
                    }
                }
                return d;
            }
        }
        return pre + 1;
    }

    public final int size(int pre, int kind) {
        return kind == 1 || kind == 0 ? this.table.read4(pre, 8) : 1;
    }

    public final int attSize(int pre, int kind) {
        int s;
        int n = s = kind == 1 ? this.table.read1(pre, 0) >> 3 & 0x1F : 1;
        if (s >= 31) {
            while (s < this.meta.size - pre && this.kind(pre + s) == 3) {
                ++s;
            }
        }
        return s;
    }

    public final byte[] attValue(int att, int pre) {
        int a = pre + this.attSize(pre, this.kind(pre));
        int p = pre;
        while (++p != a) {
            if (this.nameId(p) != att) continue;
            return this.text(p, false);
        }
        return null;
    }

    public final int nameId(int pre) {
        return this.table.read2(pre, 1) & Short.MAX_VALUE;
    }

    public final byte[] name(int pre, int kind) {
        if (kind == 5) {
            byte[] name = this.text(pre, true);
            int i = Token.indexOf(name, 32);
            return i == -1 ? name : Token.substring(name, 0, i);
        }
        return (kind == 1 ? this.elemNames : this.attrNames).key(this.nameId(pre));
    }

    public final int uriId(int pre, int kind) {
        return kind == 1 || kind == 3 ? this.table.read1(pre, kind == 1 ? 3 : 11) & 0xFF : 0;
    }

    public final byte[][] qname(int pre, int kind) {
        boolean hasPrefix;
        byte[] name = this.name(pre, kind);
        byte[] uri = null;
        boolean bl = hasPrefix = Token.indexOf(name, 58) != -1;
        if (hasPrefix || !this.nspaces.isEmpty()) {
            int uriId = this.uriId(pre, kind);
            if (uriId > 0) {
                uri = this.nspaces.uri(uriId);
            } else if (hasPrefix && Token.eq(Token.prefix(name), Token.XML)) {
                uri = DataText.XML_URI;
            }
        }
        return new byte[][]{name, uri == null ? Token.EMPTY : uri};
    }

    public final boolean nsFlag(int pre) {
        return (this.table.read1(pre, 1) & 0x80) != 0;
    }

    public final Atts namespaces(int pre) {
        return this.nsFlag(pre) ? this.nspaces.values(pre, this) : new Atts();
    }

    public final long textRef(int pre) {
        return this.table.read5(pre, 3);
    }

    public abstract byte[] text(int var1, boolean var2);

    public abstract long textItr(int var1, boolean var2);

    public abstract double textDbl(int var1, boolean var2);

    public abstract int textLen(int var1, boolean var2);

    public final void update(int pre, int kind, byte[] name, byte[] uri) {
        this.meta.update();
        if (kind == 5) {
            this.updateText(pre, Token.trim(Token.concat(name, Token.SPACE, this.atom(pre))), 5);
        } else {
            int nsPre;
            byte[] prefix = Token.prefix(name);
            int oldUriId = this.nspaces.uriIdForPrefix(prefix, pre, this);
            boolean nsFlag = oldUriId == 0 && uri.length != 0 && !Token.eq(prefix, Token.XML);
            int n = nsPre = kind == 3 ? this.parent(pre, kind) : pre;
            int uriId = nsFlag ? this.nspaces.add(nsPre, prefix, uri, this) : (oldUriId != 0 && Token.eq(this.nspaces.uri(oldUriId), uri) ? oldUriId : 0);
            int size = this.size(pre, kind);
            if (kind == 3) {
                if (this.meta.updindex) {
                    if (this.meta.attrindex) {
                        this.attrIndex.delete(new ValueCache(pre, IndexType.ATTRIBUTE, this));
                    }
                    if (this.meta.tokenindex) {
                        this.tokenIndex.delete(new ValueCache(pre, IndexType.TOKEN, this));
                    }
                }
                this.table.write1(pre, 11, uriId);
                this.table.write2(pre, 1, this.attrNames.put(name));
                if (nsFlag) {
                    this.table.write2(nsPre, 1, 0x8000 | this.nameId(nsPre));
                }
                if (this.meta.updindex) {
                    if (this.meta.attrindex) {
                        this.attrIndex.add(new ValueCache(pre, IndexType.ATTRIBUTE, this));
                    }
                    if (this.meta.tokenindex) {
                        this.tokenIndex.add(new ValueCache(pre, IndexType.TOKEN, this));
                    }
                }
            } else {
                IntList pres = new IntList();
                if (this.meta.updindex && this.meta.textindex) {
                    int last = pre + size;
                    for (int curr = pre + this.attSize(pre, kind); curr < last; curr += this.size(curr, this.kind(curr))) {
                        if (this.kind(curr) != 2) continue;
                        pres.add(curr);
                    }
                    this.textIndex.delete(new ValueCache(pres, IndexType.TEXT, this));
                }
                this.table.write1(pre, 3, uriId);
                int nameId = this.elemNames.put(name);
                this.table.write2(nsPre, 1, (nsFlag || this.nsFlag(nsPre) ? 32768 : 0) | nameId);
                if (!pres.isEmpty()) {
                    this.textIndex.add(new ValueCache(pres, IndexType.TEXT, this));
                }
            }
        }
    }

    public final void update(int pre, int kind, byte[] value) {
        byte[] val = kind == 5 ? Token.trim(Token.concat(this.name(pre, kind), Token.SPACE, value)) : value;
        if (Token.eq(val, this.text(pre, kind != 3))) {
            return;
        }
        this.meta.update();
        this.updateText(pre, val, kind);
        if (kind == 0) {
            this.resources.rename(pre, value);
        }
    }

    public final void replace(int pre, DataClip source) {
        int sPre;
        this.meta.update();
        int sCount = source.size();
        int tKind = this.kind(pre);
        int tSize = this.size(pre, tKind);
        int tPar = this.parent(pre, tKind);
        this.bufferSize(sCount);
        this.indexDelete(pre, this.id(pre), tSize);
        Data sData = source.data;
        int sTopPre = source.start;
        block6: for (int sPre2 = source.start; sPre2 < source.end; ++sPre2) {
            int cDist;
            int sKind = sData.kind(sPre2);
            int sSize = sData.size(sPre2, sKind);
            int sPar = sData.parent(sPre2, sKind);
            int cPre = pre + sPre2 - source.start;
            if (sPre2 == sTopPre) {
                cDist = cPre - tPar;
                sTopPre += sSize;
            } else {
                cDist = sPre2 - sPar;
            }
            switch (sKind) {
                case 0: {
                    this.doc(sSize, sData.text(sPre2, true));
                    ++this.meta.ndocs;
                    continue block6;
                }
                case 1: {
                    byte[] en = sData.name(sPre2, sKind);
                    this.elem(cDist, this.elemNames.put(en), sData.attSize(sPre2, sKind), sSize, this.nspaces.uriIdForPrefix(Token.prefix(en), true), false);
                    continue block6;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(cDist, sData.text(sPre2, true), sKind);
                    continue block6;
                }
                case 3: {
                    byte[] an = sData.name(sPre2, sKind);
                    this.attr(cDist, this.attrNames.put(an), sData.text(sPre2, false), this.nspaces.uriIdForPrefix(Token.prefix(an), false));
                }
            }
        }
        this.table.replace(pre, this.buffer(), tSize);
        this.bufferSize(1);
        int diff = sCount - tSize;
        if (diff != 0) {
            int p = tPar;
            while (p >= 0) {
                int k = this.kind(p);
                this.size(p, k, this.size(p, k) + diff);
                p = this.parent(p, k);
            }
            this.updateDist(pre + sCount, diff);
        }
        if (sData.kind(sPre = source.start) == 3) {
            int d = 0;
            while (sPre < source.end && sData.kind(sPre++) == 3) {
                ++d;
            }
            if (d > 1) {
                this.attSize(tPar, this.kind(tPar), d + this.attSize(tPar, 1) - 1);
            }
        }
        this.indexAdd(pre, this.meta.lastid - sCount + 1, sCount, source);
    }

    public final void delete(int pre) {
        this.meta.update();
        int kind = this.kind(pre);
        int size = this.size(pre, kind);
        this.indexDelete(pre, this.id(pre), size);
        if (kind != 0 && kind != 1) {
            this.delete(pre, kind != 3);
        }
        int par = pre;
        if (kind == 3) {
            par = this.parent(par, 3);
            this.attSize(par, 1, this.attSize(par, 1) - 1);
            this.size(par, 1, this.size(par, 1) - 1);
            kind = this.kind(par);
        }
        this.nspaces.delete(pre, size, this);
        while (par > 0 && kind != 0) {
            par = this.parent(par, kind);
            kind = this.kind(par);
            this.size(par, kind, this.size(par, kind) - size);
        }
        if (this.kind(pre) == 0) {
            --this.meta.ndocs;
        }
        this.table.delete(pre, size);
        this.updateDist(pre, -size);
    }

    public final void insertAttr(int pre, int par, DataClip source) {
        for (int s = 0; s < source.fragments; ++s) {
            int start = source.start + s;
            this.insert(pre + s, par, new DataClip(source.data, start, start + 1));
        }
        this.attSize(par, 1, this.attSize(par, 1) + source.size());
    }

    public final void insert(int pre, int par, DataClip source) {
        int sTopPre;
        int sCount = source.size();
        if (sCount == 0) {
            return;
        }
        this.meta.update();
        this.resources.docs();
        int bSize = Math.min(sCount, 256);
        this.bufferSize(bSize);
        NSScope nsScope = new NSScope(pre, this);
        Data sdata = source.data;
        int c = 0;
        int sPre = sTopPre = source.start;
        while (sPre < source.end) {
            int nDist;
            if (c != 0 && c % bSize == 0) {
                this.insert(pre + c - bSize);
            }
            int sKind = sdata.kind(sPre);
            int sSize = sdata.size(sPre, sKind);
            int sPar = sdata.parent(sPre, sKind);
            int nPre = pre + c;
            if (sPre == sTopPre) {
                nDist = nPre - par;
                sTopPre += sSize;
            } else {
                nDist = sPre - sPar;
            }
            int nsPre = sKind == 0 ? -1 : nPre - nDist;
            nsScope.loop(nsPre, c);
            switch (sKind) {
                case 0: {
                    nsScope.open(nPre);
                    this.doc(sSize, sdata.text(sPre, true));
                    ++this.meta.ndocs;
                    break;
                }
                case 1: {
                    boolean nsFlag = nsScope.open(nPre, sdata.namespaces(sPre));
                    byte[] name = sdata.name(sPre, sKind);
                    this.elem(nDist, this.elemNames.put(name), sdata.attSize(sPre, sKind), sSize, this.nspaces.uriIdForPrefix(Token.prefix(name), true), nsFlag);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(nDist, sdata.text(sPre, true), sKind);
                    break;
                }
                case 3: {
                    byte[] name = sdata.name(sPre, sKind);
                    int uriId = sdata.uriId(sPre, sKind);
                    if (uriId != 0) {
                        byte[] prefix = Token.prefix(name);
                        byte[] uri = sdata.nspaces.uri(uriId);
                        uriId = this.nspaces.uriIdForPrefix(prefix, false);
                        if (uriId == 0 && !Token.eq(prefix, Token.XML)) {
                            uriId = this.nspaces.add(nsPre, prefix, uri, this);
                            this.table.write2(nsPre, 1, 0x8000 | this.nameId(nsPre));
                        }
                    }
                    this.attr(nDist, this.attrNames.put(name), sdata.text(sPre, false), uriId);
                }
            }
            nsScope.shift(1);
            ++sPre;
            ++c;
        }
        nsScope.close();
        if (this.bp != 0) {
            this.insert(pre + c - 1 - (c - 1) % bSize);
        }
        this.bufferSize(1);
        int cPre = par;
        while (cPre >= 0) {
            int cKind = this.kind(cPre);
            this.size(cPre, cKind, this.size(cPre, cKind) + sCount);
            cPre = this.parent(cPre, cKind);
        }
        this.indexAdd(pre, this.id(pre), sCount, source);
        this.updateDist(pre + sCount, sCount);
    }

    private void updateDist(int pre, int size) {
        if (this.updateDists) {
            int k;
            for (int p = pre; p < this.meta.size && (k = this.kind(p)) != 0; p += this.size(p, k)) {
                this.dist(p, k, this.dist(p, k) + size);
            }
        }
    }

    public final void id(int pre, int value) {
        this.table.write4(pre, 12, value);
    }

    public final void size(int pre, int kind, int value) {
        if (kind == 1 || kind == 0) {
            this.table.write4(pre, 8, value);
        }
    }

    protected final void textRef(int pre, long off) {
        this.table.write5(pre, 3, off);
    }

    protected abstract void updateText(int var1, byte[] var2, int var3);

    public final void dist(int pre, int kind, int value) {
        if (kind == 3) {
            this.table.write1(pre, 0, value << 3 | 3);
        } else if (kind != 0) {
            this.table.write4(pre, kind == 1 ? 4 : 8, value);
        }
    }

    private void attSize(int pre, int kind, int value) {
        if (kind == 1) {
            this.table.write1(pre, 0, Math.min(value, 31) << 3 | 1);
        }
    }

    public final void nsFlag(int pre, boolean nsFlag) {
        this.table.write1(pre, 1, this.table.read1(pre, 1) & 0x7F | (nsFlag ? 128 : 0));
    }

    public final void insert(int pre) {
        this.table.insert(pre, this.buffer());
    }

    protected abstract void delete(int var1, boolean var2);

    private void bufferSize(int size) {
        int bs = size << 4;
        if (this.b.length != bs) {
            this.b = new byte[bs];
        }
    }

    public final void doc(int size, byte[] value) {
        int id = this.newID();
        long v = this.textRef(value, true);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(id >> 24);
        this.s(id >> 16);
        this.s(id >> 8);
        this.s(id);
    }

    public final void elem(int dist, int nameId, int asize, int size, int uriId, boolean nsFlag) {
        int id = this.newID();
        int n = nsFlag ? 128 : 0;
        this.s(Math.min(31, asize) << 3 | 1);
        this.s(n | (byte)(nameId >> 8));
        this.s(nameId);
        this.s(uriId);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(id >> 24);
        this.s(id >> 16);
        this.s(id >> 8);
        this.s(id);
    }

    public final void text(int dist, byte[] value, int kind) {
        int id = this.newID();
        long v = this.textRef(value, true);
        this.s(kind);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(id >> 24);
        this.s(id >> 16);
        this.s(id >> 8);
        this.s(id);
    }

    public final void attr(int dist, int nameId, byte[] value, int uriId) {
        int id = this.newID();
        long v = this.textRef(value, false);
        this.s(Math.min(31, dist) << 3 | 3);
        this.s(nameId >> 8);
        this.s(nameId);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(uriId);
        this.s(id >> 24);
        this.s(id >> 16);
        this.s(id >> 8);
        this.s(id);
    }

    private void s(int value) {
        this.b[this.bp++] = (byte)value;
    }

    private int newID() {
        return ++this.meta.lastid;
    }

    private void s(long value) {
        this.b[this.bp++] = (byte)value;
    }

    private byte[] buffer() {
        byte[] bb = this.bp == this.b.length ? this.b : Arrays.copyOf(this.b, this.bp);
        this.bp = 0;
        return bb;
    }

    protected abstract long textRef(byte[] var1, boolean var2);

    protected final void indexDelete(int pre, int id, int size) {
        if (id != -1) {
            this.resources.delete(pre, size);
        }
        if (this.meta.updindex) {
            if (this.meta.textindex) {
                this.textIndex.delete(new ValueCache(pre, size, IndexType.TEXT, this));
            }
            if (this.meta.attrindex) {
                this.attrIndex.delete(new ValueCache(pre, size, IndexType.ATTRIBUTE, this));
            }
            if (this.meta.tokenindex) {
                this.tokenIndex.delete(new ValueCache(pre, size, IndexType.TOKEN, this));
            }
            if (id != -1) {
                this.idmap.delete(pre, id, -size);
            }
        }
    }

    protected final void indexAdd(int pre, int id, int size, DataClip clip) {
        if (id != -1) {
            this.resources.insert(pre, clip);
        }
        if (this.meta.updindex) {
            if (id != -1) {
                this.idmap.insert(pre, id, size);
            }
            if (this.meta.textindex) {
                this.textIndex.add(new ValueCache(pre, size, IndexType.TEXT, this));
            }
            if (this.meta.attrindex) {
                this.attrIndex.add(new ValueCache(pre, size, IndexType.ATTRIBUTE, this));
            }
            if (this.meta.tokenindex) {
                this.tokenIndex.add(new ValueCache(pre, size, IndexType.TOKEN, this));
            }
        }
    }

    public abstract boolean inMemory();

    @Override
    public int compareTo(Data data) {
        if (this == data) {
            return 0;
        }
        IOFile path1 = this.meta.path;
        IOFile path2 = data.meta.path;
        String source1 = path1 == null ? this.meta.original : path1.path();
        String source2 = path2 == null ? data.meta.original : path2.path();
        return source1.compareTo(source2);
    }

    public final String toString() {
        int max = 20;
        DataPrinter dp = new DataPrinter(this);
        dp.add(0, 20);
        return this.meta.size > 20 ? dp + "..." : dp.toString();
    }
}

