/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import org.basex.BaseXServer;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.Set;
import org.basex.core.jobs.JobException;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;

public abstract class Sandbox {
    private static final String BASEURI = new File(".").getAbsolutePath();
    protected static final int DB_PORT = 9996;
    protected static final int STOP_PORT = 9999;
    protected static final int HTTP_PORT = 9998;
    protected static final String REST = "rest";
    protected static final String HTTP_ROOT = "http://localhost:9998/";
    protected static final String REST_ROOT = "http://localhost:9998/rest/";
    protected static final PrintStream OUT = System.out;
    protected static final PrintStream ERR = System.err;
    protected static final String NAME = Util.className(Sandbox.class);
    protected static Context context;

    protected static String execute(Command cmd) {
        try {
            return cmd.execute(context);
        }
        catch (BaseXException ex) {
            Util.stack(ex);
            throw new AssertionError(ex.getMessage(), ex);
        }
    }

    protected static void set(Option<?> option, Object value) {
        Sandbox.execute(new Set(option.name(), value));
    }

    protected static String query(String query) {
        try {
            return Sandbox.eval(query);
        }
        catch (JobException ex) {
            return "";
        }
        catch (IOException | QueryException ex) {
            Util.stack(ex);
            AssertionError err = new AssertionError((Object)("Query failed:\n" + query));
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String eval(String query) throws QueryException, IOException {
        ArrayOutput ao = new ArrayOutput();
        try (QueryProcessor qp = new QueryProcessor(query, BASEURI, context);){
            qp.parse();
            qp.register(context);
            try (Serializer ser = qp.getSerializer(ao);){
                qp.value().serialize(ser);
            }
            finally {
                qp.unregister(context);
            }
        }
        return ao.toString();
    }

    protected static void write(IOFile file, String data) {
        try {
            file.write(Token.token(data));
        }
        catch (IOException ex) {
            Util.stack(ex);
            throw new AssertionError(ex.getMessage(), ex);
        }
    }

    public static void initSandbox() {
        IOFile sb = Sandbox.sandbox();
        sb.delete();
        if (!sb.md()) {
            throw Util.notExpected("Sandbox could not be created.", new Object[0]);
        }
        String path = sb.path();
        Prop.put(StaticOptions.DBPATH, path + "/data");
        Prop.put(StaticOptions.WEBPATH, path + "/webapp");
        Prop.put(StaticOptions.RESTXQPATH, path + "/webapp");
        Prop.put(StaticOptions.REPOPATH, path + "/repo");
        Prop.put(StaticOptions.SERVERPORT, Integer.toString(9996));
        context = new Context();
    }

    public static void finishSandbox() {
        context.close();
        Prop.clear();
        if (!Sandbox.sandbox().delete()) {
            throw Util.notExpected("Sandbox could not be deleted.", new Object[0]);
        }
    }

    public static BaseXServer createServer(String ... args) throws IOException {
        StringList sl = new StringList("-z", "-p9996", "-q");
        for (String arg : args) {
            sl.add(arg);
        }
        BaseXServer server = new BaseXServer((String[])sl.finish());
        server.context.soptions.set(StaticOptions.DBPATH, Sandbox.sandbox().path());
        return server;
    }

    public static void stopServer(BaseXServer server) {
        if (server != null) {
            server.stop();
        }
    }

    public static ClientSession createClient(String ... login) throws IOException {
        String user = login.length > 0 ? login[0] : "admin";
        String pass = login.length > 1 ? login[1] : "admin";
        return new ClientSession("localhost", 9996, user, pass);
    }

    public static IOFile sandbox() {
        return new IOFile(Prop.TEMPDIR, NAME + '/');
    }

    public static String normNL(String result) {
        return result.replaceAll("(\r?\n|\r) *", "\n");
    }

    public static final class Client
    extends Thread {
        private final CountDownLatch startSignal;
        private final CountDownLatch stopSignal;
        private final ClientSession session = Sandbox.createClient(new String[0]);
        private final Command cmd;
        public String error;

        public Client(Command c, CountDownLatch start, CountDownLatch stop) throws IOException {
            this.cmd = c;
            this.startSignal = start;
            this.stopSignal = stop;
            this.start();
        }

        @Override
        public void run() {
            try {
                if (this.startSignal != null) {
                    this.startSignal.await();
                }
                this.session.execute(this.cmd);
                this.session.close();
            }
            catch (Throwable ex) {
                this.error = "\n" + this.cmd + '\n' + ex;
            }
            finally {
                if (this.stopSignal != null) {
                    this.stopSignal.countDown();
                }
            }
        }
    }
}

