/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.list.ElementList;

public final class BoolList
extends ElementList {
    private boolean[] list;

    public BoolList() {
        this(8);
    }

    public BoolList(int capacity) {
        this.list = new boolean[capacity];
    }

    public BoolList add(boolean element) {
        int s = this.size;
        boolean[] lst = this.list;
        if (s == lst.length) {
            lst = Arrays.copyOf(lst, this.newSize());
        }
        lst[s] = element;
        this.list = lst;
        this.size = s + 1;
        return this;
    }

    public boolean get(int index) {
        return this.list[index];
    }

    public void set(int index, boolean element) {
        if (index >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public boolean pop() {
        return this.list[--this.size];
    }

    public void push(boolean element) {
        this.add(element);
    }

    public boolean peek() {
        return this.list[this.size - 1];
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public boolean[] next() {
        boolean[] lst = Arrays.copyOf(this.list, this.size);
        this.reset();
        return lst;
    }

    public boolean[] finish() {
        boolean[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoolList)) {
            return false;
        }
        BoolList bl = (BoolList)obj;
        if (this.size != bl.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == bl.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

