/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.GDt;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.Uln;
import org.basex.query.value.item.Uri;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public enum AtomType implements Type
{
    ITEM("item", null, Token.EMPTY, false, false, false, false, Type.ID.ITEM),
    UTY("untyped", null, QueryText.XS_URI, false, false, false, false, Type.ID.UTY),
    ATY("anyType", null, QueryText.XS_URI, false, false, false, false, Type.ID.ATY),
    AST("anySimpleType", null, QueryText.XS_URI, false, false, false, false, Type.ID.AST),
    AAT("anyAtomicType", ITEM, QueryText.XS_URI, false, false, false, false, Type.ID.AAT){

        @Override
        public Atm cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Atm(item.string(info));
        }

        @Override
        public Atm cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return new Atm(value.toString());
        }
    }
    ,
    ATM("untypedAtomic", AAT, QueryText.XS_URI, false, true, false, true, Type.ID.ATM){

        @Override
        public Atm cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Atm(item.string(info));
        }

        @Override
        public Atm cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return new Atm(value.toString());
        }
    }
    ,
    STR("string", AAT, QueryText.XS_URI, false, false, true, true, Type.ID.STR){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Str.get(item.string(info));
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Str.get(value, qc, info);
        }
    }
    ,
    NST("normalizedString", STR, QueryText.XS_URI, false, false, true, true, Type.ID.NST){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            byte[] str = item.string(info);
            int sl = str.length;
            for (int s = 0; s < sl; ++s) {
                byte b = str[s];
                if (b != 9 && b != 13 && b != 10) continue;
                str[s] = 32;
            }
            return new Str(str, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    TOK("token", NST, QueryText.XS_URI, false, false, true, true, Type.ID.TOK){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Str(Token.normalize(item.string(info)), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    LAN("language", TOK, QueryText.XS_URI, false, false, true, true, Type.ID.LAN){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!LANGPATTERN.matcher(Token.string(v)).matches()) {
                throw this.castError(item, info);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    NMT("NMTOKEN", TOK, QueryText.XS_URI, false, false, true, true, Type.ID.NMT){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!XMLToken.isNMToken(v)) {
                throw this.castError(item, info);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    NAM("Name", TOK, QueryText.XS_URI, false, false, true, true, Type.ID.NAM){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!XMLToken.isName(v)) {
                throw this.castError(item, info);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    NCN("NCName", NAM, QueryText.XS_URI, false, false, true, true, Type.ID.NCN){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Str(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    ID("ID", NCN, QueryText.XS_URI, false, false, true, true, Type.ID.ID){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Str(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    IDR("IDREF", NCN, QueryText.XS_URI, false, false, true, true, Type.ID.IDR){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Str(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    ENT("ENTITY", NCN, QueryText.XS_URI, false, false, true, true, Type.ID.ENT){

        @Override
        public Str cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Str(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    NUM("numeric", AAT, QueryText.XS_URI, true, false, false, true, Type.ID.NUM){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return item.type.isNumber() ? item : Dbl.get(this.checkNum(item, info).dbl(info));
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    FLT("float", NUM, QueryText.XS_URI, true, false, false, true, Type.ID.FLT){

        @Override
        public Flt cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Flt.get(this.checkNum(item, info).flt(info));
        }

        @Override
        public Flt cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DBL("double", NUM, QueryText.XS_URI, true, false, false, true, Type.ID.DBL){

        @Override
        public Dbl cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Dbl.get(this.checkNum(item, info).dbl(info));
        }

        @Override
        public Dbl cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DEC("decimal", NUM, QueryText.XS_URI, true, false, false, true, Type.ID.DEC){

        @Override
        public Dec cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Dec.get(this.checkNum(item, info).dec(info));
        }

        @Override
        public Dec cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return Dec.get(new BigDecimal(value.toString()));
        }
    }
    ,
    PDC("precisionDecimal", null, QueryText.XS_URI, true, false, false, true, Type.ID.PDC),
    ITR("integer", DEC, QueryText.XS_URI, true, false, false, true, Type.ID.ITR){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return Int.get(this.checkLong(value, 0L, 0L, info));
        }
    }
    ,
    NPI("nonPositiveInteger", ITR, QueryText.XS_URI, true, false, false, true, Type.ID.NPI){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, Long.MIN_VALUE, 0L, info), this);
        }
    }
    ,
    NIN("negativeInteger", NPI, QueryText.XS_URI, true, false, false, true, Type.ID.NIN){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, Long.MIN_VALUE, -1L, info), this);
        }
    }
    ,
    LNG("long", ITR, QueryText.XS_URI, true, false, false, true, Type.ID.LNG){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 0L, 0L, info), this);
        }
    }
    ,
    INT("int", LNG, QueryText.XS_URI, true, false, false, true, Type.ID.INT){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, Integer.MIN_VALUE, Integer.MAX_VALUE, info), this);
        }
    }
    ,
    SHR("short", INT, QueryText.XS_URI, true, false, false, true, Type.ID.SHR){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, -32768L, 32767L, info), this);
        }
    }
    ,
    BYT("byte", SHR, QueryText.XS_URI, true, false, false, true, Type.ID.BYT){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, -128L, 127L, info), this);
        }
    }
    ,
    NNI("nonNegativeInteger", ITR, QueryText.XS_URI, true, false, false, true, Type.ID.NNI){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 0L, Long.MAX_VALUE, info), this);
        }
    }
    ,
    ULN("unsignedLong", NNI, QueryText.XS_URI, true, false, false, true, Type.ID.ULN){

        @Override
        public Uln cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Uln cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            Item item = value instanceof Item ? (Item)value : Str.get(value.toString());
            BigDecimal v = this.checkNum(item, info).dec(info);
            BigDecimal i = v.setScale(0, RoundingMode.DOWN);
            if (v.signum() < 0 || v.compareTo(Uln.MAXULN) > 0 || item.type.isStringOrUntyped() && !v.equals(i)) {
                throw this.castError(item, info);
            }
            return Uln.get(i.toBigInteger());
        }
    }
    ,
    UIN("unsignedInt", ULN, QueryText.XS_URI, true, false, false, true, Type.ID.UIN){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 0L, 0xFFFFFFFFL, info), this);
        }
    }
    ,
    USH("unsignedShort", UIN, QueryText.XS_URI, true, false, false, true, Type.ID.USH){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 0L, 65535L, info), this);
        }
    }
    ,
    UBY("unsignedByte", USH, QueryText.XS_URI, true, false, false, true, Type.ID.UBY){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 0L, 255L, info), this);
        }
    }
    ,
    PIN("positiveInteger", NNI, QueryText.XS_URI, true, false, false, true, Type.ID.PIN){

        @Override
        public Int cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, sc, info);
        }

        @Override
        public Int cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Int(this.checkLong(value, 1L, Long.MAX_VALUE, info), this);
        }
    }
    ,
    DUR("duration", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.DUR){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                return new Dur((Dur)item);
            }
            if (30.str(item)) {
                return new Dur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    YMD("yearMonthDuration", DUR, QueryText.XS_URI, false, false, false, true, Type.ID.YMD){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                return new YMDur((Dur)item);
            }
            if (31.str(item)) {
                return new YMDur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DTD("dayTimeDuration", DUR, QueryText.XS_URI, false, false, false, true, Type.ID.DTD){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                return new DTDur((Dur)item);
            }
            if (32.str(item)) {
                return new DTDur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DTM("dateTime", AAT, QueryText.XS_URI, false, false, false, true, Type.ID.DTM){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DAT) {
                return new Dtm((ADate)item);
            }
            if (33.str(item)) {
                return new Dtm(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DTS("dateTimeStamp", null, QueryText.XS_URI, false, false, false, true, Type.ID.DTS),
    DAT("date", AAT, QueryText.XS_URI, false, false, false, true, Type.ID.DAT){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM) {
                return new Dat((ADate)item);
            }
            if (34.str(item)) {
                return new Dat(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    TIM("time", AAT, QueryText.XS_URI, false, false, false, true, Type.ID.TIM){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM) {
                return new Tim((ADate)item);
            }
            if (35.str(item)) {
                return new Tim(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    YMO("gYearMonth", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.YMO){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM || item.type == DAT) {
                return new GDt((ADate)item, this);
            }
            if (36.str(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    YEA("gYear", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.YEA){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM || item.type == DAT) {
                return new GDt((ADate)item, this);
            }
            if (37.str(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    MDA("gMonthDay", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.MDA){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM || item.type == DAT) {
                return new GDt((ADate)item, this);
            }
            if (38.str(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    DAY("gDay", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.DAY){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM || item.type == DAT) {
                return new GDt((ADate)item, this);
            }
            if (39.str(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    MON("gMonth", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.MON){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type == DTM || item.type == DAT) {
                return new GDt((ADate)item, this);
            }
            if (40.str(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, sc, info);
        }
    }
    ,
    BLN("boolean", AAT, QueryText.XS_URI, false, false, false, true, Type.ID.BLN){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof ANum) {
                return Bln.get(item.bool(info));
            }
            if (41.str(item)) {
                return Bln.get(Bln.parse(item, info));
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Bln cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return Bln.get(value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString()));
        }
    }
    ,
    BIN("binary", AAT, QueryText.BASEX_URI, false, false, false, true, Type.ID.BIN),
    B64("base64Binary", BIN, QueryText.XS_URI, false, false, false, true, Type.ID.B64){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof Bin) {
                return org.basex.query.value.item.B64.get((Bin)item, info);
            }
            if (42.str(item)) {
                return org.basex.query.value.item.B64.get(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return value instanceof byte[] ? org.basex.query.value.item.B64.get((byte[])value) : org.basex.query.value.item.B64.get(Token.token(value.toString()), info);
        }
    }
    ,
    HEX("hexBinary", BIN, QueryText.XS_URI, false, false, false, true, Type.ID.HEX){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item instanceof Bin) {
                return new Hex((Bin)item, info);
            }
            if (43.str(item)) {
                return new Hex(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            return new Hex(value instanceof byte[] ? (byte[])value : Token.token(value.toString()), info);
        }
    }
    ,
    URI("anyURI", AAT, QueryText.XS_URI, false, false, true, true, Type.ID.URI){

        @Override
        public Uri cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (!item.type.isStringOrUntyped()) {
                throw QueryError.typeError(item, this, info);
            }
            Uri u = Uri.uri(item.string(info));
            if (!u.isValid()) {
                throw this.castError(item, info);
            }
            return u;
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return Uri.uri(value.toString());
        }
    }
    ,
    QNM("QName", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.QNM){

        @Override
        public QNm cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
            if (item.type != STR && !item.type.isUntyped()) {
                throw QueryError.typeError(item, this, info);
            }
            byte[] nm = Token.trim(item.string(info));
            if (!XMLToken.isQName(nm)) {
                throw this.castError(item, info);
            }
            QNm qn = new QNm(nm, sc);
            if (!qn.hasURI() && qn.hasPrefix()) {
                throw QueryError.NSDECL_X.get(info, new Object[]{qn.prefix()});
            }
            return qn;
        }

        @Override
        public QNm cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return value instanceof QName ? new QNm((QName)value) : new QNm(value.toString());
        }
    }
    ,
    NOT("NOTATION", AAT, QueryText.XS_URI, false, false, false, false, Type.ID.NOT),
    JAVA("java", ITEM, QueryText.BASEX_URI, true, true, true, false, Type.ID.JAVA){

        @Override
        public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) {
            return new Jav(item, qc);
        }

        @Override
        public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) {
            return new Jav(value, qc);
        }
    };

    private static final Pattern LANGPATTERN;
    public static final AtomType[] VALUES;
    public final QNm name;
    public final AtomType parent;
    private final Type.ID id;
    private final boolean numeric;
    private final boolean untyped;
    private final boolean string;
    private final boolean sortable;
    private EnumMap<Occ, SeqType> seqTypes;

    private AtomType(String name, AtomType parent, byte[] uri, boolean numeric, boolean untyped, boolean string2, boolean sortable, Type.ID id) {
        this.name = new QNm(name, uri);
        this.parent = parent;
        this.numeric = numeric;
        this.untyped = untyped;
        this.string = string2;
        this.sortable = sortable;
        this.id = id;
    }

    @Override
    public Item cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        if (item.type == this) {
            return item;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        throw Util.notExpected(value, new Object[0]);
    }

    @Override
    public final Item castString(String value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        return this.cast(value, qc, sc, info);
    }

    @Override
    public final SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public final boolean eq(Type type) {
        return this == type;
    }

    @Override
    public final boolean instanceOf(Type type) {
        return this == type || this.parent != null && this.parent.instanceOf(type);
    }

    @Override
    public final Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (type instanceof AtomType) {
            ArrayList<AtomType> arr = new ArrayList<AtomType>();
            AtomType at = (AtomType)type;
            while ((at = at.parent) != null) {
                arr.add(at);
            }
            AtomType p = this;
            while ((p = p.parent) != null) {
                if (!arr.contains(p)) continue;
                return p;
            }
        }
        return ITEM;
    }

    @Override
    public final Type intersect(Type type) {
        return this.instanceOf(type) ? this : (type.instanceOf(this) ? type : null);
    }

    @Override
    public final boolean isNumber() {
        return this.numeric;
    }

    @Override
    public final boolean isUntyped() {
        return this.untyped;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return this.numeric || this.untyped;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return this.string || this.untyped;
    }

    @Override
    public final boolean isSortable() {
        return this.sortable;
    }

    @Override
    public final byte[] string() {
        return this.name.string();
    }

    @Override
    public final AtomType atomic() {
        return this.instanceOf(AAT) ? this : null;
    }

    @Override
    public final Type.ID id() {
        return this.id;
    }

    @Override
    public final String toString() {
        boolean xs = Token.eq(QueryText.XS_URI, this.name.uri());
        TokenBuilder tb = new TokenBuilder();
        if (xs) {
            tb.add(NSGlobal.prefix(this.name.uri())).add(58);
        }
        tb.add(this.name.string());
        if (!xs) {
            tb.add("()");
        }
        return tb.toString();
    }

    final Item checkNum(Item item, InputInfo info) throws QueryException {
        Type type = item.type;
        if (item instanceof ANum || type.isStringOrUntyped() && type != URI || type == BLN) {
            return item;
        }
        throw QueryError.typeError(item, this, info);
    }

    final long checkLong(Object value, long min, long max, InputInfo info) throws QueryException {
        Item item = value instanceof Item ? (Item)value : Str.get(value.toString());
        this.checkNum(item, info);
        Type type = item.type;
        if (type == DBL || type == FLT) {
            double d = item.dbl(info);
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw QueryError.valueError(this, item.string(info), info);
            }
            if (min != max && (d < (double)min || d > (double)max)) {
                throw this.castError(item, info);
            }
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                throw QueryError.INTRANGE_X.get(info, d);
            }
            return (long)d;
        }
        long l = item.itr(info);
        if (min != max && (l < min || l > max)) {
            throw this.castError(item, info);
        }
        return l;
    }

    static boolean str(Item item) {
        Type type = item.type;
        return type.isStringOrUntyped() && type != URI;
    }

    final byte[] checkName(Item item, InputInfo info) throws QueryException {
        byte[] v = Token.normalize(item.string(info));
        if (!XMLToken.isNCName(v)) {
            throw this.castError(item, info);
        }
        return v;
    }

    public final QueryException castError(Item item, InputInfo info) {
        return QueryError.FUNCCAST_X_X_X.get(info, item.type, this, item);
    }

    public final QueryException castError(byte[] value, InputInfo info) {
        return QueryError.FUNCCAST_X_X.get(info, this, QueryError.chop(value, info));
    }

    @Override
    public final boolean nsSensitive() {
        return this.instanceOf(QNM) || this.instanceOf(NOT);
    }

    public static AtomType find(QNm type, boolean all) {
        if (!Token.eq(type.uri(), QueryText.BASEX_URI)) {
            for (AtomType tp : VALUES) {
                if (!tp.name.eq(type) || !all && tp.parent == null) continue;
                return tp;
            }
        }
        return null;
    }

    static Type getType(Type.ID id) {
        for (AtomType tp : VALUES) {
            if (tp.id != id) continue;
            return tp;
        }
        return null;
    }

    static {
        LANGPATTERN = Pattern.compile("[A-Za-z]{1,8}(-[A-Za-z0-9]{1,8})*");
        VALUES = AtomType.values();
    }
}

