/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.math.BigDecimal;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public final class DecSeq
extends NativeSeq {
    private final BigDecimal[] values;

    private DecSeq(BigDecimal[] values) {
        super(values.length, (Type)AtomType.DEC);
        this.values = values;
    }

    @Override
    public Dec itemAt(long pos) {
        return Dec.get(this.values[(int)pos]);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof DecSeq ? Array.equals(this.values, ((DecSeq)obj).values) : super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        BigDecimal[] tmp = new BigDecimal[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DecSeq.get(tmp);
    }

    public BigDecimal[] toJava() {
        return this.values;
    }

    private static Value get(BigDecimal[] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Dec.get(values[0]) : new DecSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        BigDecimal[] tmp = new BigDecimal[size];
        int t = 0;
        for (Value value : values) {
            int vs = (int)value.size();
            if (value instanceof DecSeq) {
                DecSeq seq = (DecSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = value.itemAt(v).dec(null);
            }
        }
        return DecSeq.get(tmp);
    }
}

