/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class DblSeq
extends NativeSeq {
    private final double[] values;

    private DblSeq(double[] values) {
        super(values.length, (Type)AtomType.DBL);
        this.values = values;
    }

    @Override
    public Dbl itemAt(long pos) {
        return Dbl.get(this.values[(int)pos]);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof DblSeq ? Arrays.equals(this.values, ((DblSeq)obj).values) : super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        double[] tmp = new double[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DblSeq.get(tmp);
    }

    public double[] toJava() {
        return this.values;
    }

    public static Value get(double[] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Dbl.get(values[0]) : new DblSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        double[] tmp = new double[size];
        int t = 0;
        for (Value value : values) {
            int vs = (int)value.size();
            if (value instanceof DblSeq) {
                DblSeq seq = (DblSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = value.itemAt(v).dbl(null);
            }
        }
        return DblSeq.get(tmp);
    }
}

