/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class BytSeq
extends NativeSeq {
    private final byte[] values;

    private BytSeq(byte[] values) {
        super(values.length, (Type)AtomType.BYT);
        this.values = values;
    }

    @Override
    public Int itemAt(long pos) {
        return new Int(this.values[(int)pos], this.type);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof BytSeq ? Arrays.equals(this.values, ((BytSeq)obj).values) : super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        byte[] tmp = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BytSeq.get(tmp);
    }

    public byte[] toJava() {
        return this.values;
    }

    public static Value get(byte[] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Int.get(values[0], AtomType.BYT) : new BytSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        byte[] tmp = new byte[size];
        int t = 0;
        for (Value value : values) {
            int vs = (int)value.size();
            if (value instanceof BytSeq) {
                BytSeq seq = (BytSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = (byte)value.itemAt(v).itr(null);
            }
        }
        return BytSeq.get(tmp);
    }
}

