/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.HashMap;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Map
extends FItem {
    public static final Map EMPTY = new Map(TrieNode.EMPTY);
    static final int BITS = 5;
    private final TrieNode root;

    private Map(TrieNode root) {
        super(SeqType.ANY_MAP, new AnnList());
        this.root = root;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public QNm funcName() {
        return null;
    }

    @Override
    public QNm paramName(int pos) {
        return new QNm("key", "");
    }

    @Override
    public FuncType funcType() {
        return MapType.get(AtomType.AAT, SeqType.ITEM_ZM);
    }

    @Override
    public void materialize(InputInfo info) throws QueryException {
        this.root.materialize(info);
    }

    @Override
    public int stackFrameSize() {
        return 0;
    }

    @Override
    public Item invItem(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        return this.invValue(qc, info, args).item(qc, info);
    }

    @Override
    public Value invValue(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        Item key = args[0].atomItem(qc, info);
        if (key == null) {
            throw QueryError.EMPTYFOUND.get(info, new Object[0]);
        }
        return this.get(key, info);
    }

    public Map delete(Item key, InputInfo info) throws QueryException {
        TrieNode del = this.root.delete(key.hash(info), key, 0, info);
        return del == this.root ? this : (del == null ? EMPTY : new Map(del));
    }

    public Value get(Item key, InputInfo info) throws QueryException {
        Value value = this.root.get(key.hash(info), key, 0, info);
        return value == null ? Empty.SEQ : value;
    }

    public boolean contains(Item key, InputInfo info) throws QueryException {
        return this.root.contains(key.hash(info), key, 0, info);
    }

    public Map addAll(Map map, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        if (map == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(map.root, 0, merge, info, qc);
        return upd == map.root ? map : new Map(upd);
    }

    @Override
    public boolean instanceOf(Type tp) {
        return tp == AtomType.ITEM || tp instanceof FuncType && this.instanceOf((FuncType)tp, false);
    }

    @Override
    public Map coerceTo(FuncType ft, QueryContext qc, InputInfo info, boolean opt) throws QueryException {
        if (this.instanceOf(ft, true)) {
            return this;
        }
        throw QueryError.typeError(this, ft, info);
    }

    private boolean instanceOf(FuncType ft, boolean coerce) {
        if (ft instanceof ArrayType) {
            return false;
        }
        if (this.type.instanceOf(ft)) {
            return true;
        }
        SeqType[] at = ft.argTypes;
        if (!(at == null || at.length == 1 && at[0].one())) {
            return false;
        }
        SeqType ret = ft.declType;
        if (ft instanceof MapType) {
            AtomType arg = ((MapType)ft).keyType();
            if (arg == AtomType.AAT) {
                arg = null;
            }
            if (ret.eq(SeqType.ITEM_ZM)) {
                ret = null;
            }
            return arg == null && ret == null || this.root.instanceOf(arg, ret);
        }
        return coerce || ret.eq(SeqType.ITEM_ZM);
    }

    public Map put(Item key, Value value, InputInfo info) throws QueryException {
        TrieNode ins = this.root.put(key.hash(info), key, value, 0, info);
        return ins == this.root ? this : new Map(ins);
    }

    public int mapSize() {
        return this.root.size;
    }

    public Value keys() {
        ItemList items = new ItemList(this.root.size);
        this.root.keys(items);
        return items.value();
    }

    public void values(ValueBuilder vb) {
        this.root.values(vb);
    }

    public Value forEach(FItem func, QueryContext qc, InputInfo info) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        this.root.forEach(vb, func, qc, info);
        return vb.value();
    }

    @Override
    public boolean deep(Item item, InputInfo info, Collation coll) throws QueryException {
        if (item instanceof Map) {
            return this.root.deep(info, ((Map)item).root, coll);
        }
        return item instanceof FItem && !(item instanceof Array) && super.deep(item, info, coll);
    }

    @Override
    public HashMap<Object, Object> toJava() throws QueryException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Item key : this.keys()) {
            map.put(key.toJava(), this.get(key, null).toJava());
        }
        return map;
    }

    @Override
    public int hash(InputInfo info) throws QueryException {
        return this.root.hash(info);
    }

    @Override
    public String description() {
        return "map";
    }

    @Override
    public void plan(FElem plan) {
        int size = this.mapSize();
        FElem elem = this.planElem("entries", size, "type", this.seqType());
        Value keys = this.keys();
        try {
            int max = Math.min(size, 5);
            for (long i = 0L; i < (long)max; ++i) {
                Item key = keys.itemAt(i);
                Value value = this.get(key, null);
                key.plan(elem);
                value.plan(elem);
            }
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        Map.addPlan(plan, elem, new ExprInfo[0]);
    }

    public void string(boolean indent, TokenBuilder tb, int level, InputInfo info) throws QueryException {
        tb.add("map{");
        int c = 0;
        for (Item key : this.keys()) {
            Value value;
            boolean par;
            if (c++ > 0) {
                tb.add(44);
            }
            if (indent) {
                tb.add(10);
                Map.indent(tb, level + 1);
            }
            tb.add(key.toString()).add(58);
            if (indent) {
                tb.add(32);
            }
            boolean bl = par = (value = this.get(key, info)).size() != 1L;
            if (par) {
                tb.add(40);
            }
            int cc = 0;
            for (Item item : value) {
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if (item instanceof Map) {
                    ((Map)item).string(indent, tb, level + 1, info);
                    continue;
                }
                if (item instanceof Array) {
                    ((Array)item).string(indent, tb, level, info);
                    continue;
                }
                tb.add(item.toString());
            }
            if (!par) continue;
            tb.add(41);
        }
        if (indent) {
            tb.add(10);
            Map.indent(tb, level);
        }
        tb.add(125);
    }

    private static void indent(TokenBuilder tb, int level) {
        for (int l = 0; l < level; ++l) {
            tb.add("  ");
        }
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, CompileContext cc, InputInfo info) {
        return null;
    }

    @Override
    public boolean isVacuousBody() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        return "map { " + this.root.append(new StringBuilder()).toString().replaceAll(", $", "") + " }";
    }
}

