/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class B64
extends Bin {
    public static final B64 EMPTY = new B64(new byte[0]);
    private static final B64[] B64S;

    B64() {
        super(null, AtomType.B64);
    }

    public static B64 get(byte value) {
        return B64S[value & 0xFF];
    }

    public static B64 get(byte[] value) {
        return value.length == 1 ? B64.get(value[0]) : new B64(value);
    }

    public static B64 get(Bin bin, InputInfo info) throws QueryException {
        return B64.get(bin.binary(info));
    }

    public static B64 get(byte[] value, InputInfo info) throws QueryException {
        return B64.get(B64.parse(value, info));
    }

    private B64(byte[] data) {
        super(data, AtomType.B64);
    }

    @Override
    public byte[] string(InputInfo info) throws QueryException {
        return Base64.encode(this.binary(info));
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(info) : B64.parse(item, info);
        return Token.eq(this.binary(info), bin);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(info) : B64.parse(item, info);
        return Token.diff(this.binary(info), bin);
    }

    public static byte[] parse(Item item, InputInfo info) throws QueryException {
        try {
            return Base64.decode(item.string(info));
        }
        catch (IllegalArgumentException ex) {
            throw AtomType.B64.castError(item, info);
        }
    }

    public static byte[] parse(byte[] value, InputInfo info) throws QueryException {
        try {
            return Base64.decode(value);
        }
        catch (IllegalArgumentException ex) {
            throw AtomType.B64.castError(value, info);
        }
    }

    @Override
    public String toString() {
        return Util.info("\"%\"", new Object[]{Base64.encode(this.data)});
    }

    static {
        int nl = 256;
        B64S = new B64[256];
        for (int n = 0; n < 256; ++n) {
            B64.B64S[n] = new B64(new byte[]{(byte)n});
        }
    }
}

