/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.LeafNode;
import org.basex.query.value.array.PartialLeafNode;
import org.basex.query.value.array.SmallArray;
import org.basex.util.Util;

final class BigArray
extends Array {
    final Value[] left;
    final FingerTree<Value, Value> middle;
    final Value[] right;

    BigArray(Value[] left, FingerTree<Value, Value> middle, Value[] right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        assert (left.length >= 4 && left.length <= 19 && right.length >= 4 && right.length <= 19);
    }

    BigArray(Value[] left, Value[] right) {
        this.left = left;
        this.middle = FingerTree.empty();
        this.right = right;
        assert (left.length >= 4 && left.length <= 19 && right.length >= 4 && right.length <= 19);
    }

    @Override
    public boolean isEmptyArray() {
        return false;
    }

    @Override
    public long arraySize() {
        return (long)this.left.length + this.middle.size() + (long)this.right.length;
    }

    @Override
    public Value head() {
        return this.left[0];
    }

    @Override
    public Value last() {
        return this.right[this.right.length - 1];
    }

    @Override
    public Array cons(Value elem) {
        if (this.left.length < 19) {
            Value[] newLeft = BigArray.slice(this.left, -1, this.left.length);
            newLeft[0] = elem;
            return new BigArray(newLeft, this.middle, this.right);
        }
        int mid = 9;
        Value[] newLeft = BigArray.slice(this.left, -1, 9);
        newLeft[0] = elem;
        LeafNode sub = new LeafNode(BigArray.slice(this.left, 9, this.left.length));
        return new BigArray(newLeft, this.middle.cons(sub), this.right);
    }

    @Override
    public Array snoc(Value elem) {
        if (this.right.length < 19) {
            Value[] newRight = BigArray.slice(this.right, 0, this.right.length + 1);
            newRight[this.right.length] = elem;
            return new BigArray(this.left, this.middle, newRight);
        }
        int mid = 10;
        Value[] newRight = BigArray.slice(this.right, 10, this.right.length + 1);
        newRight[this.right.length - 10] = elem;
        LeafNode sub = new LeafNode(BigArray.slice(this.right, 0, 10));
        return new BigArray(this.left, this.middle.snoc(sub), newRight);
    }

    @Override
    public Array init() {
        if (this.right.length > 4) {
            return new BigArray(this.left, this.middle, BigArray.slice(this.right, 0, this.right.length - 1));
        }
        if (this.middle.isEmpty()) {
            int l = this.left.length;
            int r = this.right.length;
            int n = l + r - 1;
            if (n <= 7) {
                Value[] out = new Value[n];
                System.arraycopy(this.left, 0, out, 0, l);
                System.arraycopy(this.right, 0, out, l, r - 1);
                return new SmallArray(out);
            }
            int ll = n / 2;
            int rl = n - ll;
            int move = l - ll;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            System.arraycopy(this.left, 0, newLeft, 0, ll);
            System.arraycopy(this.left, ll, newRight, 0, move);
            System.arraycopy(this.right, 0, newRight, move, r - 1);
            return new BigArray(newLeft, newRight);
        }
        Value[] ls = ((LeafNode)this.middle.last()).values;
        Value[] rs = this.right;
        int ll = ls.length;
        int rl = rs.length;
        int n = ll + rl - 1;
        Value[] newRight = new Value[n];
        System.arraycopy(ls, 0, newRight, 0, ll);
        System.arraycopy(rs, 0, newRight, ll, rl - 1);
        return new BigArray(this.left, this.middle.init(), newRight);
    }

    @Override
    public Array tail() {
        if (this.left.length > 4) {
            return new BigArray(BigArray.slice(this.left, 1, this.left.length), this.middle, this.right);
        }
        if (this.middle.isEmpty()) {
            int l = this.left.length;
            int r = this.right.length;
            int n = l - 1 + r;
            if (n <= 7) {
                Value[] out = new Value[n];
                System.arraycopy(this.left, 1, out, 0, l - 1);
                System.arraycopy(this.right, 0, out, l - 1, r);
                return new SmallArray(out);
            }
            int ll = n / 2;
            int rl = n - ll;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            System.arraycopy(this.left, 1, newLeft, 0, l - 1);
            System.arraycopy(this.right, 0, newLeft, l - 1, r - rl);
            System.arraycopy(this.right, r - rl, newRight, 0, rl);
            return new BigArray(newLeft, newRight);
        }
        Value[] ls = this.left;
        Value[] rs = ((LeafNode)this.middle.head()).values;
        int ll = ls.length;
        int rl = rs.length;
        int n = ll - 1 + rl;
        Value[] newLeft = new Value[n];
        System.arraycopy(ls, 1, newLeft, 0, ll - 1);
        System.arraycopy(rs, 0, newLeft, ll - 1, rl);
        return new BigArray(newLeft, this.middle.tail(), this.right);
    }

    @Override
    public Array concat(Array seq) {
        if (seq.isEmptyArray()) {
            return this;
        }
        if (seq instanceof SmallArray) {
            Value[] newRight = BigArray.concat(this.right, ((SmallArray)seq).elems);
            int r = newRight.length;
            if (r <= 19) {
                return new BigArray(this.left, this.middle, newRight);
            }
            int mid = r / 2;
            Value[] leaf = BigArray.slice(newRight, 0, mid);
            FingerTree<Value, Value> newMid = this.middle.snoc(new LeafNode(leaf));
            return new BigArray(this.left, newMid, BigArray.slice(newRight, mid, r));
        }
        BigArray other = (BigArray)seq;
        Value[] ls = this.right;
        Value[] rs = other.left;
        int l = ls.length;
        int n = l + rs.length;
        int k = (n + 15 - 1) / 15;
        int s = (n + k - 1) / k;
        Node[] midNodes = new Node[k];
        int p = 0;
        for (int i = 0; i < k; ++i) {
            int curr = Math.min(n - p, s);
            Value[] arr = new Value[curr];
            int j = 0;
            while (j < curr) {
                arr[j] = p < l ? ls[p] : rs[p - l];
                ++j;
                ++p;
            }
            midNodes[i] = new LeafNode(arr);
        }
        return new BigArray(this.left, this.middle.concat(midNodes, n, other.middle), other.right);
    }

    @Override
    public Value get(long index) {
        if (index < (long)this.left.length) {
            return this.left[(int)index];
        }
        long midSize = (long)this.left.length + this.middle.size();
        if (index >= midSize) {
            return this.right[(int)(index - midSize)];
        }
        return this.middle.get(index - (long)this.left.length);
    }

    @Override
    public Array put(long pos, Value val) {
        long p = pos;
        if (p < (long)this.left.length) {
            Value[] newLeft = (Value[])this.left.clone();
            newLeft[(int)p] = val;
            return new BigArray(newLeft, this.middle, this.right);
        }
        long m = this.middle.size();
        if ((p -= (long)this.left.length) < m) {
            return new BigArray(this.left, this.middle.set(p, val), this.right);
        }
        Value[] newRight = (Value[])this.right.clone();
        newRight[(int)(p -= m)] = val;
        return new BigArray(this.left, this.middle, newRight);
    }

    @Override
    public Array reverseArray(QueryContext qc) {
        int i;
        qc.checkStop();
        int l = this.left.length;
        int r = this.right.length;
        Value[] newLeft = new Value[r];
        Value[] newRight = new Value[l];
        for (i = 0; i < r; ++i) {
            newLeft[i] = this.right[r - 1 - i];
        }
        for (i = 0; i < l; ++i) {
            newRight[i] = this.left[l - 1 - i];
        }
        return new BigArray(newLeft, this.middle.reverse(qc), newRight);
    }

    @Override
    public Array insertBefore(long pos, Value value, QueryContext qc) {
        qc.checkStop();
        int l = this.left.length;
        if (pos <= (long)l) {
            int p = (int)pos;
            Value[] temp = BigArray.slice(this.left, 0, l + 1);
            System.arraycopy(temp, p, temp, p + 1, l - p);
            temp[p] = value;
            if (l < 19) {
                return new BigArray(temp, this.middle, this.right);
            }
            int m = (l + 1) / 2;
            return new BigArray(BigArray.slice(temp, 0, m), this.middle.cons(new LeafNode(BigArray.slice(temp, m, l + 1))), this.right);
        }
        long midSize = this.middle.size();
        if (pos - (long)l < midSize) {
            return new BigArray(this.left, this.middle.insert(pos - (long)l, value, qc), this.right);
        }
        int r = this.right.length;
        int p = (int)(pos - (long)l - midSize);
        Value[] temp = BigArray.slice(this.right, 0, r + 1);
        System.arraycopy(temp, p, temp, p + 1, r - p);
        temp[p] = value;
        if (r < 19) {
            return new BigArray(this.left, this.middle, temp);
        }
        int m = (r + 1) / 2;
        return new BigArray(this.left, this.middle.snoc(new LeafNode(BigArray.slice(temp, 0, m))), BigArray.slice(temp, m, r + 1));
    }

    @Override
    public Array remove(long pos, QueryContext qc) {
        qc.checkStop();
        if (pos < (long)this.left.length) {
            int p = (int)pos;
            int l = this.left.length;
            if (l > 4) {
                Value[] newLeft = new Value[l - 1];
                System.arraycopy(this.left, 0, newLeft, 0, p);
                System.arraycopy(this.left, p + 1, newLeft, p, newLeft.length - p);
                return new BigArray(newLeft, this.middle, this.right);
            }
            if (this.middle.isEmpty()) {
                int r = this.right.length;
                int n = l - 1 + r;
                Value[] vals = new Value[n];
                System.arraycopy(this.left, 0, vals, 0, p);
                System.arraycopy(this.left, p + 1, vals, p, l - 1 - p);
                System.arraycopy(this.right, 0, vals, l - 1, r);
                return BigArray.fromMerged(vals);
            }
            Value[] head = ((LeafNode)this.middle.head()).values;
            int r = head.length;
            int n = l - 1 + r;
            if (r > 8) {
                int move = (r - 8 + 1) / 2;
                Value[] newLeft = new Value[l - 1 + move];
                System.arraycopy(this.left, 0, newLeft, 0, p);
                System.arraycopy(this.left, p + 1, newLeft, p, l - 1 - p);
                System.arraycopy(head, 0, newLeft, l - 1, move);
                Value[] newHead = BigArray.slice(head, move, r);
                return new BigArray(newLeft, this.middle.replaceHead(new LeafNode(newHead)), this.right);
            }
            Value[] newLeft = new Value[n];
            System.arraycopy(this.left, 0, newLeft, 0, p);
            System.arraycopy(this.left, p + 1, newLeft, p, l - 1 - p);
            System.arraycopy(head, 0, newLeft, l - 1, r);
            return new BigArray(newLeft, this.middle.tail(), this.right);
        }
        long midSize = this.middle.size();
        long rightOffset = (long)this.left.length + midSize;
        if (pos >= rightOffset) {
            int p = (int)(pos - rightOffset);
            int r = this.right.length;
            if (r > 4) {
                Value[] newRight = new Value[r - 1];
                System.arraycopy(this.right, 0, newRight, 0, p);
                System.arraycopy(this.right, p + 1, newRight, p, r - 1 - p);
                return new BigArray(this.left, this.middle, newRight);
            }
            if (this.middle.isEmpty()) {
                int l = this.left.length;
                int n = l + r - 1;
                Value[] vals = new Value[n];
                System.arraycopy(this.left, 0, vals, 0, l);
                System.arraycopy(this.right, 0, vals, l, p);
                System.arraycopy(this.right, p + 1, vals, l + p, r - 1 - p);
                return BigArray.fromMerged(vals);
            }
            Value[] last = ((LeafNode)this.middle.last()).values;
            int l = last.length;
            int n = l + r - 1;
            if (l > 8) {
                int move = (l - 8 + 1) / 2;
                Value[] newLast = BigArray.slice(last, 0, l - move);
                Value[] newRight = new Value[r - 1 + move];
                System.arraycopy(last, l - move, newRight, 0, move);
                System.arraycopy(this.right, 0, newRight, move, p);
                System.arraycopy(this.right, p + 1, newRight, move + p, r - 1 - p);
                return new BigArray(this.left, this.middle.replaceLast(new LeafNode(newLast)), newRight);
            }
            Value[] newRight = new Value[n];
            System.arraycopy(last, 0, newRight, 0, l);
            System.arraycopy(this.right, 0, newRight, l, p);
            System.arraycopy(this.right, p + 1, newRight, l + p, r - 1 - p);
            return new BigArray(this.left, this.middle.init(), newRight);
        }
        TreeSlice<Value, Value> slice = this.middle.remove(pos - (long)this.left.length, qc);
        if (slice.isTree()) {
            return new BigArray(this.left, slice.getTree(), this.right);
        }
        Value[] mid = ((PartialLeafNode)slice.getPartial()).elems;
        int l = this.left.length;
        int m = mid.length;
        int r = this.right.length;
        if (l > r) {
            int move = (l - 4 + 1) / 2;
            Value[] newLeft = BigArray.slice(this.left, 0, l - move);
            Value[] newMid = BigArray.slice(this.left, l - move, l + m);
            System.arraycopy(mid, 0, newMid, move, m);
            return new BigArray(newLeft, FingerTree.singleton(new LeafNode(newMid)), this.right);
        }
        if (r > 4) {
            int move = (r - 4 + 1) / 2;
            Value[] newMid = BigArray.slice(mid, 0, m + move);
            System.arraycopy(this.right, 0, newMid, m, move);
            Value[] newRight = BigArray.slice(this.right, move, r);
            return new BigArray(this.left, FingerTree.singleton(new LeafNode(newMid)), newRight);
        }
        int ml = m / 2;
        int mr = m - ml;
        Value[] newLeft = BigArray.slice(this.left, 0, l + ml);
        System.arraycopy(mid, 0, newLeft, l, ml);
        Value[] newRight = BigArray.slice(this.right, -mr, r);
        System.arraycopy(mid, ml, newRight, 0, mr);
        return new BigArray(newLeft, newRight);
    }

    @Override
    public Array subArray(long pos, long len, QueryContext qc) {
        Value[] newRight;
        FingerTree<Value, Value> newMiddle;
        FingerTree<Value, Value> mid1;
        Value[] newLeft;
        FingerTree<Value, Value> mid;
        int inRight;
        qc.checkStop();
        long midSize = this.middle.size();
        long size = (long)this.left.length + midSize + (long)this.right.length;
        if (len == 0L) {
            return Array.empty();
        }
        if (len == size) {
            return this;
        }
        long end = pos + len;
        if (end <= (long)this.left.length) {
            int p = (int)pos;
            int n = (int)len;
            if (len <= 7L) {
                return new SmallArray(BigArray.slice(this.left, p, p + n));
            }
            int mid2 = p + n / 2;
            return new BigArray(BigArray.slice(this.left, p, mid2), BigArray.slice(this.left, mid2, p + n));
        }
        long rightOffset = (long)this.left.length + midSize;
        if (pos >= rightOffset) {
            int p = (int)(pos - rightOffset);
            int n = (int)len;
            if (len <= 7L) {
                return new SmallArray(BigArray.slice(this.right, p, p + n));
            }
            int mid3 = p + n / 2;
            return new BigArray(BigArray.slice(this.right, p, mid3), BigArray.slice(this.right, mid3, p + n));
        }
        int inLeft = pos < (long)this.left.length ? (int)((long)this.left.length - pos) : 0;
        int n = inRight = end > rightOffset ? (int)(end - rightOffset) : 0;
        if (inLeft >= 4 && inRight >= 4) {
            Value[] newLeft2 = inLeft == this.left.length ? this.left : BigArray.slice(this.left, (int)pos, this.left.length);
            Value[] newRight2 = inRight == this.right.length ? this.right : BigArray.slice(this.right, 0, inRight);
            return new BigArray(newLeft2, this.middle, newRight2);
        }
        if (this.middle.isEmpty()) {
            Value[] out;
            if (inLeft == 0) {
                out = inRight == this.right.length ? this.right : BigArray.slice(this.right, 0, inRight);
            } else if (inRight == 0) {
                out = inLeft == this.left.length ? this.left : BigArray.slice(this.left, this.left.length - inLeft, this.left.length);
            } else {
                out = BigArray.slice(this.left, this.left.length - inLeft, this.left.length + inRight);
                System.arraycopy(this.right, 0, out, inLeft, inRight);
            }
            return BigArray.fromMerged(out);
        }
        long inMiddle = len - (long)inLeft - (long)inRight;
        if (inMiddle == midSize) {
            mid = this.middle;
        } else {
            long off = pos < (long)this.left.length ? 0L : pos - (long)this.left.length;
            TreeSlice<Value, Value> slice = this.middle.slice(off, inMiddle);
            if (!slice.isTree()) {
                Value[] single = ((PartialLeafNode)slice.getPartial()).elems;
                if (inLeft > 0) {
                    Value[] out = BigArray.slice(this.left, (int)pos, this.left.length + single.length);
                    System.arraycopy(single, 0, out, inLeft, single.length);
                    return BigArray.fromMerged(out);
                }
                if (inRight > 0) {
                    Value[] out = BigArray.slice(single, 0, single.length + inRight);
                    System.arraycopy(this.right, 0, out, single.length, inRight);
                    return BigArray.fromMerged(out);
                }
                return new SmallArray(single);
            }
            mid = slice.getTree();
        }
        int off = this.left.length - inLeft;
        if (inLeft >= 4) {
            newLeft = inLeft == this.left.length ? this.left : BigArray.slice(this.left, off, this.left.length);
            mid1 = mid;
        } else {
            Value[] head = ((LeafNode)mid.head()).values;
            if (inLeft == 0) {
                newLeft = head;
            } else {
                newLeft = BigArray.slice(head, -inLeft, head.length);
                System.arraycopy(this.left, off, newLeft, 0, inLeft);
            }
            mid1 = mid.tail();
        }
        if (inRight >= 4) {
            newMiddle = mid1;
            newRight = inRight == this.right.length ? this.right : BigArray.slice(this.right, 0, inRight);
        } else if (!mid1.isEmpty()) {
            Value[] last = ((LeafNode)mid1.last()).values;
            newMiddle = mid1.init();
            if (inRight == 0) {
                newRight = last;
            } else {
                newRight = BigArray.slice(last, 0, last.length + inRight);
                System.arraycopy(this.right, 0, newRight, last.length, inRight);
            }
        } else {
            if (inRight == 0) {
                return BigArray.fromMerged(newLeft);
            }
            int n2 = newLeft.length + inRight;
            Value[] out = BigArray.slice(newLeft, 0, n2);
            System.arraycopy(this.right, 0, out, newLeft.length, inRight);
            return BigArray.fromMerged(out);
        }
        return new BigArray(newLeft, newMiddle, newRight);
    }

    private static Array fromMerged(Value[] merged) {
        if (merged.length <= 7) {
            return new SmallArray(merged);
        }
        int mid = merged.length / 2;
        return new BigArray(BigArray.slice(merged, 0, mid), BigArray.slice(merged, mid, merged.length));
    }

    @Override
    public ListIterator<Value> iterator(long start) {
        ListIterator<Value> sub;
        int startPos;
        final Value[] ls = this.left;
        final Value[] rs = this.right;
        final int l = ls.length;
        final int r = rs.length;
        final long m = this.middle.size();
        if (start < (long)l) {
            startPos = (int)start - l;
            sub = this.middle.listIterator(0L);
        } else if (start - (long)l < m) {
            startPos = 0;
            sub = this.middle.listIterator(start - (long)l);
        } else {
            startPos = (int)(start - (long)l - m) + 1;
            sub = this.middle.listIterator(m);
        }
        return new ListIterator<Value>(){
            int pos;
            {
                this.pos = startPos;
            }

            @Override
            public int nextIndex() {
                return this.pos < 0 ? l + this.pos : (this.pos > 0 ? (int)((long)l + m + (long)this.pos - 1L) : l + sub.nextIndex());
            }

            @Override
            public boolean hasNext() {
                return this.pos <= r;
            }

            @Override
            public Value next() {
                if (this.pos < 0) {
                    return ls[l + this.pos++];
                }
                if (this.pos == 0) {
                    if (sub.hasNext()) {
                        return (Value)sub.next();
                    }
                    this.pos = 1;
                }
                return rs[this.pos++ - 1];
            }

            @Override
            public int previousIndex() {
                return this.pos < 0 ? l + this.pos - 1 : (this.pos > 0 ? (int)((long)l + m + (long)this.pos - 2L) : l + sub.previousIndex());
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > -l;
            }

            @Override
            public Value previous() {
                if (this.pos > 0 && --this.pos > 0) {
                    return rs[this.pos - 1];
                }
                if (this.pos == 0) {
                    if (sub.hasPrevious()) {
                        return (Value)sub.previous();
                    }
                    this.pos = -1;
                    return ls[l - 1];
                }
                return ls[l + --this.pos];
            }

            @Override
            public void add(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void set(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    void checkInvariants() {
        int l = this.left.length;
        int r = this.right.length;
        if (l < 4 || l > 19) {
            throw new AssertionError((Object)("Left digit: " + l));
        }
        if (r < 4 || r > 19) {
            throw new AssertionError((Object)("Right digit: " + r));
        }
        this.middle.checkInvariants();
    }

    @Override
    Array consSmall(Value[] values) {
        int a = values.length;
        int b = this.left.length;
        int n = a + b;
        if (n <= 19) {
            return new BigArray(BigArray.concat(values, this.left), this.middle, this.right);
        }
        if (a >= 4 && 8 <= b && b <= 15) {
            return new BigArray(values, this.middle.cons(new LeafNode(this.left)), this.right);
        }
        int mid = n / 2;
        int move = mid - a;
        Value[] newLeft = BigArray.slice(values, 0, mid);
        System.arraycopy(this.left, 0, newLeft, a, move);
        LeafNode leaf = new LeafNode(BigArray.slice(this.left, move, b));
        return new BigArray(newLeft, this.middle.cons(leaf), this.right);
    }
}

