/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class TransformWith
extends Arr {
    public TransformWith(InputInfo info, Expr source, Expr modify) {
        super(info, SeqType.NOD_ZM, source, modify);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushFocus(null);
        try {
            Expr expr = super.compile(cc);
            return expr;
        }
        finally {
            cc.removeFocus();
        }
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.adoptType(this.exprs[0]);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.exprs[0]);
        Expr modify = this.exprs[1];
        modify.checkUp();
        if (!modify.isVacuous() && !modify.has(Flag.UPD)) {
            throw QueryError.UPMODIFY.get(this.info, new Object[0]);
        }
    }

    @Override
    public BasicIter<?> iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Updates upd = qc.updates();
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        ValueBuilder vb = new ValueBuilder(qc);
        try {
            Item item;
            Iter iter = this.exprs[0].iter(qc);
            while ((item = qc.next(iter)) != null) {
                Updates updates;
                if (!(item instanceof ANode)) {
                    throw QueryError.UPSOURCE_X.get(this.info, item);
                }
                item = ((ANode)item).dbNodeCopy(qc.context.options, qc);
                qf.value = item;
                qc.updates = updates = new Updates(true);
                updates.addData(item.data());
                Value value = this.exprs[1].value(qc);
                if (!value.isEmpty()) {
                    throw QueryError.UPMODIFY.get(this.info, new Object[0]);
                }
                updates.prepare(qc);
                updates.apply(qc);
                vb.add(item);
            }
        }
        finally {
            qc.updates = upd;
            qf.value = cv;
        }
        return vb.value();
    }

    @Override
    public boolean has(Flag ... flags) {
        if (Flag.UPD.in(flags) && this.exprs[0].has(Flag.UPD)) {
            return true;
        }
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new TransformWith(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof TransformWith && super.equals(obj);
    }

    @Override
    public String toString() {
        return this.toString(" update ");
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }
}

