/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.fn.Parse;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class FnParseJson
extends Parse {
    private static final FuncType STRFUNC = FuncType.get(SeqType.STR_O, SeqType.STR_O);

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.exprs[0].atomItem(qc, this.info);
        return item == null ? null : this.parse(this.toToken(item), false, qc);
    }

    @Override
    protected final Expr opt(CompileContext cc) {
        return this.optFirst();
    }

    final Item parse(byte[] json, boolean xml, QueryContext qc) throws QueryException {
        FItem fallback;
        JsonParserOptions opts = new JsonParserOptions();
        if (this.exprs.length > 1) {
            new FuncOptions(this.info).acceptUnknown().assign(this.toMap(this.exprs[1], qc), opts);
        }
        boolean esc = opts.get(JsonParserOptions.ESCAPE);
        FuncItem fb = opts.get(JsonParserOptions.FALLBACK);
        FItem fItem = fallback = fb == null ? null : STRFUNC.cast(fb, qc, this.sc, this.info);
        if (esc && fallback != null) {
            throw QueryError.OPTION_JSON_X.get(this.info, "Escaping cannot be combined with a fallback function.");
        }
        try {
            opts.set(JsonOptions.FORMAT, xml ? JsonOptions.JsonFormat.BASIC : JsonOptions.JsonFormat.XQUERY);
            JsonConverter conv = JsonConverter.get(opts);
            if (!esc && fallback != null) {
                conv.fallback(string -> {
                    try {
                        return Token.string(fallback.invokeItem(qc, this.info, Str.get(string)).string(this.info));
                    }
                    catch (QueryException ex) {
                        throw new QueryRTException(ex);
                    }
                });
            }
            return conv.convert(json, null);
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        catch (QueryIOException ex) {
            Util.debug(ex);
            QueryException qe = ex.getCause(this.info);
            QueryError error = qe.error();
            String message = ex.getLocalizedMessage();
            if (error == QueryError.JSON_PARSE_X_X_X) {
                throw QueryError.PARSE_JSON_X.get(this.info, message);
            }
            if (error == QueryError.JSON_PARSE_X) {
                throw QueryError.DUPLICATE_JSON_X.get(this.info, message);
            }
            if (error == QueryError.JSON_OPTIONS_X) {
                throw QueryError.OPTION_JSON_X.get(this.info, message);
            }
            throw qe;
        }
    }
}

