/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public class FnMin
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.minmax(CmpV.OpV.GT, qc);
    }

    final Item minmax(CmpV.OpV cmp, QueryContext qc) throws QueryException {
        Item item2;
        Collation coll = this.toCollation(1, qc);
        Expr expr = this.exprs[0];
        Item item1 = this.value(cmp);
        if (item1 != null) {
            return item1;
        }
        if (expr instanceof Range) {
            Value value = expr.value(qc);
            return value.isEmpty() ? null : value.itemAt(cmp == CmpV.OpV.GT ? 0L : value.size() - 1L);
        }
        Iter iter = expr.atomIter(qc, this.info);
        item1 = iter.next();
        if (item1 == null) {
            return null;
        }
        Type type1 = item1.type;
        if (!type1.isSortable()) {
            throw QueryError.CMP_X.get(this.info, type1);
        }
        if (item1 instanceof AStr) {
            Item item22;
            while ((item22 = qc.next(iter)) != null) {
                if (!(item22 instanceof AStr)) {
                    throw QueryError.CMP_X_X_X.get(this.info, type1, item22.type, item22);
                }
                Type type2 = item22.type;
                if (cmp.eval(item1, item22, coll, this.sc, this.info)) {
                    item1 = item22;
                }
                if (type1 == type2 || item1.type != AtomType.URI) continue;
                item1 = AtomType.STR.cast(item1, qc, this.sc, this.info);
            }
            return item1;
        }
        if (type1 == AtomType.BLN || item1 instanceof ADate || item1 instanceof Dur || item1 instanceof Bin) {
            Item item;
            while ((item = qc.next(iter)) != null) {
                if (type1 != item.type) {
                    throw QueryError.CMP_X_X_X.get(this.info, type1, item.type, item);
                }
                if (!cmp.eval(item1, item, coll, this.sc, this.info)) continue;
                item1 = item;
            }
            return item1;
        }
        if (type1.isUntyped()) {
            item1 = AtomType.DBL.cast(item1, qc, this.sc, this.info);
        }
        while ((item2 = qc.next(iter)) != null) {
            AtomType type = this.numType(item1, item2);
            if (cmp.eval(item1, item2, coll, this.sc, this.info) || Double.isNaN(item2.dbl(this.info))) {
                item1 = item2;
            }
            if (type == null) continue;
            item1 = type.cast(item1, qc, this.sc, this.info);
        }
        return item1;
    }

    private AtomType numType(Item item1, Item item2) throws QueryException {
        Type type2 = item2.type;
        if (type2.isUntyped()) {
            return AtomType.DBL;
        }
        Type type1 = item1.type;
        if (!(item2 instanceof ANum)) {
            throw QueryError.CMP_X_X_X.get(this.info, type1, type2, item2);
        }
        return type1 == type2 ? null : (type1 == AtomType.DBL || type2 == AtomType.DBL ? AtomType.DBL : (type1 == AtomType.FLT || type2 == AtomType.FLT ? AtomType.FLT : null));
    }

    private Item value(CmpV.OpV cmp) {
        Expr expr = this.exprs[0];
        if (expr instanceof Value && this.exprs.length < 2) {
            Type type;
            Item item = null;
            Value value = (Value)expr;
            if (value instanceof RangeSeq) {
                RangeSeq seq = (RangeSeq)value;
                item = seq.itemAt(cmp == CmpV.OpV.GT ^ seq.asc ? seq.size() - 1L : 0L);
            }
            if (expr instanceof SingletonSeq || expr instanceof Item) {
                item = value.itemAt(cmp == CmpV.OpV.GT ? 0L : expr.size() - 1L);
            }
            if (item != null && ((type = item.seqType().type).isNumber() || type.instanceOf(AtomType.STR))) {
                return item;
            }
        }
        return null;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optMinmax(CmpV.OpV.GT);
    }

    final Expr optMinmax(CmpV.OpV cmp) {
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        Type type = st.type;
        if (type.isSortable()) {
            if (type.isUntyped()) {
                type = AtomType.DBL;
            } else if (st.one() && this.exprs.length < 2) {
                return expr;
            }
            this.exprType.assign(type);
            Item item = this.value(cmp);
            if (item != null) {
                return item;
            }
        }
        return this.optFirst();
    }
}

