/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccess;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.name.BackupDrop;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DbDropBackup
extends DbAccess {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        if (!Databases.validName(name)) {
            throw QueryError.DB_NAME_X.get(this.info, name);
        }
        StringList backups = qc.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw QueryError.DB_NOBACKUP_X.get(this.info, name);
        }
        Updates updates = qc.updates();
        for (String backup : backups) {
            updates.add(new BackupDrop(backup, this.info, qc), qc);
        }
        return null;
    }
}

