/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.client;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.client.ClientFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;

public final class ClientQuery
extends ClientFn {
    private static final Pattern QUERYPAT = Pattern.compile("\\[(.*?)] (.*)", 8);

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        ClientSession cs = this.session(qc, false);
        String query = Token.string(this.toToken(this.exprs[1], qc));
        ValueBuilder vb = new ValueBuilder(qc);
        try (org.basex.api.client.ClientQuery cq = cs.query(query);){
            Object result;
            for (Map.Entry<String, Value> binding : this.toBindings(2, qc).entrySet()) {
                String key = binding.getKey();
                Value value = binding.getValue();
                if (key.isEmpty()) {
                    cq.context(value);
                    continue;
                }
                cq.bind(key, value);
            }
            cq.cache(true);
            while (cq.more()) {
                result = cq.next();
                Type type = cq.type();
                if (type instanceof FuncType) {
                    throw QueryError.CLIENT_FITEM_X.get(this.info, result);
                }
                vb.add(cq.type().castString((String)result, qc, this.sc, this.info));
            }
            result = vb.value();
            return result;
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (BaseXException ex) {
            QueryException queryException;
            String msg;
            Matcher m = QUERYPAT.matcher(ex.getMessage());
            if (!m.find()) {
                throw QueryError.CLIENT_QUERY_X.get(this.info, ex);
            }
            String name = m.group(1);
            QueryException exc = QueryError.get(name, msg = m.group(2), this.info);
            if (exc == null) {
                queryException = new QueryException(this.info, new QNm(name), msg, new Object[0]);
                throw queryException;
            }
            queryException = exc;
            throw queryException;
        }
        catch (IOException ex) {
            throw QueryError.CLIENT_ERROR_X.get(this.info, ex);
        }
    }
}

