/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.archive.ArchOptions;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.util.InputInfo;

public final class ArchiveOptions
extends StandardFunc {
    @Override
    public Map item(QueryContext qc, InputInfo ii) throws QueryException {
        String format;
        B64 archive = this.toB64(this.exprs[0], qc, false);
        int level = -1;
        try (ArchiveIn arch = ArchiveIn.get(archive.input(this.info), this.info);){
            format = arch.format();
            while (arch.more()) {
                ZipEntry ze = arch.entry();
                if (ze.isDirectory()) continue;
                level = ze.getMethod();
                break;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
        Map map = Map.EMPTY;
        if (format != null) {
            map = map.put(Str.get(ArchOptions.FORMAT.name()), Str.get(format), ii);
        }
        if (level >= 0) {
            String lvl = level == 8 ? "deflate" : (level == 0 ? "stored" : "unknown");
            map = map.put(Str.get(ArchOptions.ALGORITHM.name()), Str.get(lvl), ii);
        }
        return map;
    }
}

