/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class FuncLit
extends Single
implements Scope {
    private final VarScope vs;
    private final QNm name;
    private final Var[] params;
    private final AnnList anns;
    private boolean compiled;

    FuncLit(AnnList anns, QNm name, Var[] params, Expr expr, SeqType seqType, VarScope vs, InputInfo info) {
        super(info, expr, seqType);
        this.anns = anns;
        this.name = name;
        this.params = params;
        this.vs = vs;
    }

    @Override
    public void comp(CompileContext cc) {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
            this.expr.markTailCalls(null);
        }
        catch (QueryException e) {
            this.expr = cc.error(e, this);
        }
        finally {
            cc.removeScope(this);
        }
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.comp(cc);
        return this.optimize(cc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) {
        return new FuncItem(this.vs.sc, this.anns, this.name, this.params, (FuncType)this.seqType().type, this.expr, qc.focus.copy(), this.vs.stackSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        VarScope vsc = new VarScope(this.vs.sc);
        cc.pushScope(vsc);
        try {
            int pl = this.params.length;
            Var[] vars = new Var[pl];
            for (int p = 0; p < pl; ++p) {
                vars[p] = cc.copy(this.params[p], vm);
            }
            Expr ex = this.expr.copy(cc, vm);
            FuncLit funcLit = new FuncLit(this.anns, this.name, vars, ex, this.seqType(), vsc, this.info);
            return funcLit;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.inlineFunc(this);
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.prefixId()).add(35).addExt(this.params.length, new Object[0]).toString();
    }
}

