/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class InvDocTest
extends Test {
    private final Data data;
    private final IntList pres;

    private InvDocTest(IntList pres, Data data) {
        super(NodeType.DOC);
        this.pres = pres;
        this.data = data;
    }

    static Test get(Value root) {
        IntList pres;
        if (root == null) {
            return KindTest.DOC;
        }
        Data data = root.data();
        if (data == null || data.meta.ndocs == 1) {
            return KindTest.DOC;
        }
        if (root instanceof DBNodeSeq) {
            DBNodeSeq seq = (DBNodeSeq)root;
            if (seq.all()) {
                return KindTest.DOC;
            }
            pres = new IntList(seq.pres());
        } else {
            pres = new IntList((int)root.size());
            for (Item item : root) {
                pres.add(((DBNode)item).pre());
            }
        }
        return new InvDocTest(pres.sort(), data);
    }

    @Override
    public boolean eq(ANode node) {
        if (!(node instanceof DBNode)) {
            return false;
        }
        DBNode db = (DBNode)node;
        return this.data == db.data() && this.pres.sortedIndexOf(db.pre()) >= 0;
    }

    @Override
    public Test copy() {
        return new InvDocTest(this.pres, this.data);
    }

    @Override
    public Test intersect(Test other) {
        throw Util.notExpected(this, new Object[0]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InvDocTest)) {
            return false;
        }
        InvDocTest it = (InvDocTest)obj;
        return this.data == it.data && this.pres.equals(it.pres);
    }

    @Override
    public String toString() {
        return new TokenBuilder(NodeType.DOC.string()).add("(...)").toString();
    }
}

