/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class IndexAccess
extends Simple {
    IndexDb db;

    IndexAccess(IndexDb db, InputInfo info, IndexType type) {
        super(info, type == IndexType.TEXT || type == IndexType.FULLTEXT ? SeqType.TXT_ZM : SeqType.ATT_ZM);
        this.db = db;
    }

    @Override
    public abstract NodeIter iter(QueryContext var1) throws QueryException;

    @Override
    public boolean has(Flag ... flags) {
        return this.db.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.db.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.db.count(var);
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        IndexDb sub = this.db.inline(var, ex, cc);
        if (sub != null) {
            this.db = sub;
            return this;
        }
        return null;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.db.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.db.exprSize() + 1;
    }

    @Override
    public final boolean iterable() {
        return this.seqType().zeroOrOne() || this.db.iterable();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IndexAccess && this.db.equals(((IndexAccess)obj).db);
    }
}

