/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.OrderKey;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class OrderBy
extends Clause {
    private VarRef[] refs;
    private final OrderKey[] keys;

    public OrderBy(VarRef[] refs, OrderKey[] keys, InputInfo info) {
        super(info, SeqType.ITEM_ZM, new Var[0]);
        this.refs = refs;
        this.keys = keys;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Value[][] tpls;
            private Integer[] perm;
            int pos;

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                if (this.tpls == null) {
                    this.sort(qc);
                }
                if (this.pos == this.tpls.length) {
                    return false;
                }
                int p = this.perm[this.pos++];
                Value[] tuple = this.tpls[p];
                this.tpls[p] = null;
                int rl = OrderBy.this.refs.length;
                for (int r = 0; r < rl; ++r) {
                    qc.set(((OrderBy)OrderBy.this).refs[r].var, tuple[r]);
                }
                return true;
            }

            private void sort(QueryContext qc) throws QueryException {
                ArrayList<Value[]> tuples = new ArrayList<Value[]>();
                while (sub.next(qc)) {
                    int kl = OrderBy.this.keys.length;
                    Item[] key = new Item[kl];
                    for (int k = 0; k < kl; ++k) {
                        key[k] = ((OrderBy)OrderBy.this).keys[k].expr.atomItem(qc, ((OrderBy)OrderBy.this).keys[k].info);
                    }
                    tuples.add(key);
                    int rl = OrderBy.this.refs.length;
                    Value[] vals = new Value[rl];
                    for (int r = 0; r < rl; ++r) {
                        vals[r] = OrderBy.this.refs[r].value(qc);
                    }
                    tuples.add(vals);
                }
                int len = tuples.size() >>> 1;
                Item[][] ks = new Item[len][];
                this.perm = new Integer[len];
                this.tpls = new Value[len][];
                for (int i = 0; i < len; ++i) {
                    this.perm[i] = i;
                    this.tpls[i] = (Value[])tuples.get(i << 1 | 1);
                    ks[i] = (Item[])tuples.get(i << 1);
                }
                tuples = null;
                try {
                    Arrays.sort(this.perm, (x, y) -> {
                        try {
                            Item[] a = ks[x];
                            Item[] b = ks[y];
                            int kl = OrderBy.this.keys.length;
                            for (int k = 0; k < kl; ++k) {
                                int c;
                                OrderKey key = OrderBy.this.keys[k];
                                Item m = a[k];
                                Item n = b[k];
                                if (m == Dbl.NAN || m == Flt.NAN) {
                                    m = null;
                                }
                                if (n == Dbl.NAN || n == Flt.NAN) {
                                    n = null;
                                }
                                if (m != null && n != null && !m.comparable(n)) {
                                    throw QueryError.typeError(n, m.type, key.info);
                                }
                                int n2 = m == null ? (n == null ? 0 : (key.least ? -1 : 1)) : (n == null ? (key.least ? 1 : -1) : (c = m.diff(n, key.coll, key.info)));
                                if (c == 0) continue;
                                return key.desc ? -c : c;
                            }
                            return 0;
                        }
                        catch (QueryException ex) {
                            throw new QueryRTException(ex);
                        }
                    });
                }
                catch (QueryRTException ex) {
                    throw ex.getCause();
                }
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        for (OrderKey key : this.keys) {
            if (!key.has(flags)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrderBy compile(CompileContext cc) throws QueryException {
        for (OrderKey key : this.keys) {
            key.compile(cc);
        }
        return this;
    }

    @Override
    public OrderBy optimize(CompileContext cc) {
        return this;
    }

    @Override
    public boolean removable(Var var) {
        for (OrderKey key : this.keys) {
            if (key.removable(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.keys);
    }

    @Override
    public Clause inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        int r = this.refs.length;
        while (--r >= 0) {
            if (!var.is(this.refs[r].var)) continue;
            this.refs = Array.delete(this.refs, r);
        }
        return OrderBy.inlineAll(this.keys, var, ex, cc) ? this.optimize(cc) : null;
    }

    @Override
    public OrderBy copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new OrderBy((VarRef[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.refs), (OrderKey[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.keys), this.info));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return OrderBy.visitAll(visitor, this.keys);
    }

    @Override
    boolean clean(IntObjMap<Var> decl, BitArray used) {
        int len = this.refs.length;
        int r = this.refs.length;
        while (--r >= 0) {
            if (used.get(this.refs[r].var.id)) continue;
            this.refs = Array.delete(this.refs, r);
        }
        if (this.refs.length == used.cardinality()) {
            return this.refs.length != len;
        }
        int id = used.nextSet(0);
        while (id >= 0) {
            block5: {
                for (VarRef ref : this.refs) {
                    if (ref.var.id != id) {
                        continue;
                    }
                    break block5;
                }
                this.refs = Array.add(this.refs, new VarRef(this.info, decl.get(id)));
            }
            id = used.nextSet(id + 1);
        }
        return true;
    }

    @Override
    boolean skippable(Clause cl) {
        return cl instanceof Where;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.keys);
    }

    @Override
    public int exprSize() {
        int size = 0;
        for (VarRef varRef : this.refs) {
            size += ((Expr)varRef).exprSize();
        }
        for (ParseExpr parseExpr : this.keys) {
            size += parseExpr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy o = (OrderBy)obj;
        return Array.equals(this.refs, o.refs) && Array.equals(this.keys, o.keys);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        for (OrderKey key : this.keys) {
            key.plan(elem);
        }
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("order").append(' ').append("by");
        int kl = this.keys.length;
        for (int k = 0; k < kl; ++k) {
            sb.append(k == 0 ? " " : ", ").append(this.keys[k]);
        }
        return sb.toString();
    }
}

