/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.List;
import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.ForLet;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class For
extends ForLet {
    Var pos;
    Var score;
    final boolean empty;

    public For(Var var, Var pos, Var score, Expr expr, boolean empty) {
        super(var.info, SeqType.ITEM_ZO, var, expr, score != null, For.vars(var, pos, score));
        this.pos = pos;
        this.score = score;
        this.empty = empty;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Iter iter;
            private long p;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean next(QueryContext qc) throws QueryException {
                while (true) {
                    boolean s;
                    Item item = null;
                    if (this.iter != null) {
                        if (For.this.scoring) {
                            s = qc.scoring;
                            try {
                                qc.scoring = true;
                                item = qc.next(this.iter);
                            }
                            finally {
                                qc.scoring = s;
                            }
                        } else {
                            item = qc.next(this.iter);
                        }
                    }
                    if (item != null) {
                        ++this.p;
                        qc.set(For.this.var, item);
                        if (For.this.pos != null) {
                            qc.set(For.this.pos, Int.get(this.p));
                        }
                        if (For.this.score != null) {
                            qc.set(For.this.score, Dbl.get(item.score()));
                        }
                        return true;
                    }
                    if (For.this.empty && this.iter != null && this.p == 0L) {
                        qc.set(For.this.var, Empty.SEQ);
                        if (For.this.pos != null) {
                            qc.set(For.this.pos, Int.get(this.p));
                        }
                        if (For.this.score != null) {
                            qc.set(For.this.score, Dbl.ZERO);
                        }
                        this.iter = null;
                        return true;
                    }
                    if (!sub.next(qc)) {
                        return false;
                    }
                    if (For.this.scoring) {
                        s = qc.scoring;
                        try {
                            qc.scoring = true;
                            this.iter = For.this.expr.iter(qc);
                        }
                        finally {
                            qc.scoring = s;
                        }
                    } else {
                        this.iter = For.this.expr.iter(qc);
                    }
                    this.p = 0L;
                }
            }
        };
    }

    @Override
    public For optimize(CompileContext cc) throws QueryException {
        SeqType type = this.expr.seqType();
        this.exprType.assign(type.type, this.empty && type.mayBeEmpty() ? Occ.ZERO_ONE : Occ.ONE);
        this.var.refineType(this.seqType(), this.size(), cc);
        this.var.data = this.expr.data();
        if (this.pos != null) {
            this.pos.refineType(SeqType.ITR_O, 1L, cc);
        }
        if (this.score != null) {
            this.score.refineType(SeqType.DBL_O, 1L, cc);
        }
        return this;
    }

    @Override
    public For copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new For(cc.copy(this.var, vm), cc.copy(this.pos, vm), cc.copy(this.score, vm), this.expr.copy(cc, vm), this.empty));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(!this.expr.accept(visitor) || !visitor.declared(this.var) || this.pos != null && !visitor.declared(this.pos) || this.score != null && !visitor.declared(this.score));
    }

    private static Var[] vars(Var var, Var pos, Var scope) {
        Var[] varArray;
        if (pos == null) {
            if (scope == null) {
                Var[] varArray2 = new Var[1];
                varArray = varArray2;
                varArray2[0] = var;
            } else {
                Var[] varArray3 = new Var[2];
                varArray3[0] = var;
                varArray = varArray3;
                varArray3[1] = scope;
            }
        } else if (scope == null) {
            Var[] varArray4 = new Var[2];
            varArray4[0] = var;
            varArray = varArray4;
            varArray4[1] = pos;
        } else {
            Var[] varArray5 = new Var[3];
            varArray5[0] = var;
            varArray5[1] = pos;
            varArray = varArray5;
            varArray5[2] = scope;
        }
        return varArray;
    }

    boolean asLet(List<Clause> clauses, int p) {
        if (!this.expr.seqType().one()) {
            return false;
        }
        clauses.set(p, Let.fromFor(this));
        if (this.score != null) {
            clauses.add(p + 1, Let.fromForScore(this));
        }
        if (this.pos != null) {
            clauses.add(p + 1, new Let(this.pos, Int.ONE, false));
        }
        return true;
    }

    void addPredicate(Expr ex) {
        this.expr = this.expr instanceof AxisPath && !ex.has(Flag.POS) ? ((AxisPath)this.expr).addPreds(ex) : (this.expr instanceof Filter ? ((Filter)this.expr).addPred(ex) : Filter.get(this.info, this.expr, ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toPredicate(CompileContext cc, Expr ex) throws QueryException {
        if (this.empty || this.vars().length != 1 || !ex.uses(this.var) || !ex.removable(this.var)) {
            return false;
        }
        Expr pred = ex;
        cc.pushFocus(this.expr);
        try {
            Expr r = ex.inline(this.var, new ContextValue(this.info).optimize(cc), cc);
            if (r != null) {
                pred = r;
            }
        }
        finally {
            cc.removeFocus();
        }
        if (pred.seqType().mayBeNumber()) {
            pred = cc.function(Function.BOOLEAN, this.info, pred);
        }
        this.addPredicate(pred);
        return true;
    }

    @Override
    void calcSize(long[] minMax) {
        long size = this.expr.size();
        long factor = size > 0L ? size : (this.empty ? 1L : 0L);
        minMax[0] = minMax[0] * factor;
        long max = minMax[1];
        if (max > 0L) {
            minMax[1] = size < 0L ? -1L : max * factor;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof For)) {
            return false;
        }
        For f = (For)obj;
        return Objects.equals(this.pos, f.pos) && Objects.equals(this.score, f.score) && this.empty == f.empty && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem el;
        FElem elem = this.planElem(new Object[0]);
        if (this.empty) {
            elem.add(For.planAttr(Token.token("empty"), Token.TRUE));
        }
        this.var.plan(elem);
        if (this.pos != null) {
            el = new FElem("at");
            this.pos.plan(el);
            elem.add(el);
        }
        if (this.score != null) {
            el = new FElem("score");
            this.score.plan(el);
            elem.add(el);
        }
        this.expr.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("for").append(' ').append(this.var);
        if (this.empty) {
            sb.append(' ').append("allowing").append(' ').append("empty");
        }
        if (this.pos != null) {
            sb.append(' ').append("at").append(' ').append(this.pos);
        }
        if (this.score != null) {
            sb.append(' ').append("score").append(' ').append(this.score);
        }
        return sb.append(' ').append("in").append(' ').append(this.expr).toString();
    }
}

