/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.constr.Constr;
import org.basex.query.util.NSContext;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class CElem
extends CName {
    private final Atts nspaces;
    private final boolean comp;

    public CElem(StaticContext sc, InputInfo info, Expr name, Atts nspaces, Expr ... cont) {
        super("element", sc, info, SeqType.ELM_O, name, cont);
        this.nspaces = nspaces == null ? new Atts() : nspaces;
        this.comp = nspaces == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int s = this.addNS();
        try {
            Expr expr = super.compile(cc);
            return expr;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FElem item(QueryContext qc, InputInfo ii) throws QueryException {
        int s = this.addNS();
        try {
            Atts ns = new Atts();
            int nl = this.nspaces.size();
            for (int i = 0; i < nl; ++i) {
                ns.add(this.nspaces.name(i), this.nspaces.value(i));
            }
            QNm nm = this.qname(qc, true);
            byte[] cp = nm.prefix();
            byte[] cu = nm.uri();
            if (Token.eq(cp, Token.XML) ^ Token.eq(cu, QueryText.XML_URI)) {
                throw QueryError.CEXML.get(this.info, cu, cp);
            }
            if (Token.eq(cu, QueryText.XMLNS_URI)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{cu});
            }
            if (Token.eq(cp, Token.XMLNS)) {
                throw QueryError.CEINV_X.get(this.info, new Object[]{cp});
            }
            if (!nm.hasURI() && nm.hasPrefix()) {
                throw QueryError.INVPREF_X.get(this.info, nm);
            }
            if (!Token.eq(cp, Token.XML)) {
                byte[] uri = this.sc.ns.uri(cp);
                if (nm.hasURI()) {
                    if (!(this.comp || uri != null && Token.eq(uri, cu))) {
                        this.sc.ns.add(cp, cu);
                    }
                    if (!ns.contains(cp)) {
                        ns.add(cp, cu);
                    }
                } else {
                    nm.uri(uri);
                }
            }
            Constr constr = new Constr(this.info, this.sc);
            FElem node = new FElem(nm, ns, constr.children, constr.atts);
            constr.add(qc, this.exprs);
            if (constr.errAtt != null) {
                throw QueryError.NOATTALL_X.get(this.info, constr.errAtt);
            }
            if (constr.errNS != null) {
                throw QueryError.NONSALL_X.get(this.info, constr.errNS);
            }
            if (constr.duplAtt != null) {
                throw QueryError.CATTDUPL_X.get(this.info, constr.duplAtt);
            }
            if (constr.duplNS != null) {
                throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{constr.duplNS});
            }
            if (constr.nspaces.contains(Token.EMPTY) && !nm.hasURI()) {
                throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{Token.EMPTY});
            }
            Atts cns = constr.nspaces;
            int cl = cns.size();
            for (int c = 0; c < cl; ++c) {
                CElem.addNS(cns.name(c), cns.value(c), ns);
            }
            int al = constr.atts.size();
            for (int a = 0; a < al; ++a) {
                byte[] auri;
                byte[] npref;
                byte[] apref;
                ANode att = (ANode)constr.atts.get(a);
                QNm qnm = att.qname();
                if (!qnm.hasPrefix() || !qnm.hasURI() || Token.eq(apref = qnm.prefix(), Token.XML) || (npref = CElem.addNS(apref, auri = qnm.uri(), ns)) == null) continue;
                QNm aname = new QNm(Token.concat(npref, Token.COLON, qnm.local()), auri);
                constr.atts.set(a, new FAttr(aname, att.string()));
            }
            for (ANode ch : constr.children) {
                ch.optimize();
            }
            FElem fElem = node.optimize();
            return fElem;
        }
        finally {
            this.sc.ns.size(s);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new CElem(this.sc, this.info, this.name.copy(cc, vm), this.comp ? null : this.nspaces.copy(), CElem.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CElem)) {
            return false;
        }
        CElem c = (CElem)obj;
        return this.comp == c.comp && this.nspaces.equals(c.nspaces) && super.equals(obj);
    }

    private static byte[] addNS(byte[] pref, byte[] uri, Atts ns) {
        byte[] u = ns.value(pref);
        if (u == null) {
            ns.add(pref, uri);
        } else if (!Token.eq(u, uri)) {
            byte[] apref = null;
            int nl = ns.size();
            for (int n = 0; n < nl; ++n) {
                if (!Token.eq(ns.value(n), uri)) continue;
                apref = ns.name(n);
            }
            if (apref == null) {
                int i = 1;
                while (ns.contains(apref = Token.concat(pref, new byte[]{95}, Token.token(i++)))) {
                }
                ns.add(apref, uri);
            }
            return apref;
        }
        return null;
    }

    private int addNS() {
        NSContext ns = this.sc.ns;
        int size = ns.size();
        int nl = this.nspaces.size();
        for (int n = 0; n < nl; ++n) {
            ns.add(this.nspaces.name(n), this.nspaces.value(n));
        }
        return size;
    }
}

