/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Treat
extends Single {
    public Treat(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final SeqType st = this.seqType();
        final Iter iter = this.expr.iter(qc);
        final Item item = iter.next();
        if (item == null) {
            if (st.mayBeEmpty()) {
                return Empty.ITER;
            }
            throw QueryError.NOTREAT_X_X_X.get(this.info, Empty.SEQ.seqType(), st, Empty.SEQ);
        }
        if (st.zero()) {
            throw QueryError.NOTREAT_X_X_X.get(this.info, item.type, st, item);
        }
        if (st.zeroOrOne()) {
            Item next = iter.next();
            if (next != null) {
                ValueBuilder vb = new ValueBuilder(qc, item, next);
                if (iter.next() != null) {
                    vb.add(Str.get("..."));
                }
                throw QueryError.NOTREAT_X_X_X.get(this.info, this.expr.seqType(), st, vb.value());
            }
            if (!item.type.instanceOf(st.type)) {
                throw QueryError.NOTREAT_X_X_X.get(this.info, item.type, st, item);
            }
            return item.iter();
        }
        return new Iter(){
            Item it;
            {
                this.it = item;
            }

            @Override
            public Item next() throws QueryException {
                if (this.it == null) {
                    return null;
                }
                if (!this.it.type.instanceOf(st.type)) {
                    throw QueryError.NOTREAT_X_X_X.get(Treat.this.info, this.it.type, st, this.it);
                }
                Item ii = this.it;
                this.it = qc.next(iter);
                return ii;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        SeqType st = this.seqType();
        Value value = this.expr.value(qc);
        long len = value.size();
        if (len == 0L) {
            if (st.mayBeEmpty()) {
                return value;
            }
            throw QueryError.NOTREAT_X_X_X.get(this.info, Empty.SEQ.seqType(), st, Empty.SEQ);
        }
        if (st.zero()) {
            throw QueryError.NOTREAT_X_X_X.get(this.info, value.type, st, value);
        }
        if (st.zeroOrOne()) {
            if (len > 1L) {
                throw QueryError.NOTREAT_X_X_X.get(this.info, value.seqType(), st, value);
            }
            Item item = value.itemAt(0L);
            if (!item.type.instanceOf(st.type)) {
                throw QueryError.NOTREAT_X_X_X.get(this.info, item.type, st, item);
            }
            return item;
        }
        for (long i = 0L; i < len; ++i) {
            qc.checkStop();
            Item item = value.itemAt(i);
            if (item.type.instanceOf(st.type)) continue;
            throw QueryError.NOTREAT_X_X_X.get(this.info, item.type, st, item);
        }
        return value;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Treat(this.info, this.expr.copy(cc, vm), this.seqType());
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Treat && this.seqType().eq(((Treat)obj).seqType()) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Treat.addPlan(plan, this.planElem("as", this.seqType()), this.expr);
    }

    @Override
    public String toString() {
        return '(' + this.expr.toString() + ") " + "treat" + ' ' + "as" + ' ' + this.seqType();
    }
}

