/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class List
extends Arr {
    public List(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int es = this.exprs.length;
        for (int e = 0; e < es; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this.optimize(cc);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (expr == Empty.SEQ) continue;
            list.add(expr);
        }
        int ls = list.size();
        if (ls != this.exprs.length) {
            if (ls < 2) {
                return cc.replaceWith(this, ls == 0 ? Empty.SEQ : (Expr)list.get(0));
            }
            cc.info("remove % from %", Empty.SEQ, this.description());
            this.exprs = (Expr[])list.finish();
        }
        Type type = null;
        for (Expr expr : this.exprs) {
            SeqType et = expr.seqType();
            if (et.zero()) continue;
            type = type == null ? et.type : type.union(et.type);
        }
        long size = 0L;
        boolean zero = true;
        for (Expr expr : this.exprs) {
            long sz = expr.size();
            if (sz > 0L || expr.seqType().oneOrMore()) {
                zero = false;
            }
            if (size == -1L) continue;
            size = sz == -1L ? -1L : size + sz;
        }
        this.exprType.assign(type, zero ? Occ.ZERO_MORE : Occ.ONE_MORE, size);
        if (this.allAreValues(true)) {
            void var11_33;
            void var8_16;
            Object var8_15 = null;
            Value[] values = new Value[this.exprs.length];
            int vl = 0;
            for (Expr expr : this.exprs) {
                cc.qc.checkStop();
                Value value2 = expr.value(cc.qc);
                if (vl == 0) {
                    Type type2 = value2.type;
                } else if (var8_16 != null && !var8_16.eq(value2.type)) {
                    Object var8_18 = null;
                }
                values[vl++] = value2;
            }
            int sz = (int)size;
            if (var8_16 == AtomType.STR) {
                Value value = StrSeq.get(values, sz);
            } else if (var8_16 == AtomType.BLN) {
                Value value = BlnSeq.get(values, sz);
            } else if (var8_16 == AtomType.FLT) {
                Value value = FltSeq.get(values, sz);
            } else if (var8_16 == AtomType.DBL) {
                Value value = DblSeq.get(values, sz);
            } else if (var8_16 == AtomType.DEC) {
                Value value = DecSeq.get(values, sz);
            } else if (var8_16 == AtomType.BYT) {
                Value value = BytSeq.get(values, sz);
            } else if (var8_16 != null && var8_16.instanceOf(AtomType.ITR)) {
                Value value = IntSeq.get(values, sz, (Type)var8_16);
            } else {
                ValueBuilder vb = new ValueBuilder(cc.qc);
                for (int v = 0; v < vl; ++v) {
                    vb.add(values[v]);
                }
                Value value = vb.value();
            }
            return cc.replaceWith(this, (Expr)var11_33);
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final int el;
            private final Iter[] iters;
            private long[] offsets;
            private long size;
            private int e;
            {
                this.el = List.this.exprs.length;
                this.iters = new Iter[this.el];
            }

            @Override
            public Item next() throws QueryException {
                while (this.e < this.el) {
                    Item item = qc.next(this.iter(this.e));
                    if (item != null) {
                        return item;
                    }
                    ++this.e;
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                int o;
                for (o = 0; o < this.el - 1 && this.offsets[o + 1] <= i; ++o) {
                }
                return this.iter(o).get(i - this.offsets[o]);
            }

            @Override
            public long size() throws QueryException {
                if (this.offsets == null) {
                    this.offsets = new long[this.el];
                    for (int o = 0; o < this.el && this.size != -1L; ++o) {
                        this.offsets[o] = this.size;
                        long s = this.iter(o).size();
                        this.size = s == -1L || this.size + s < 0L ? -1L : this.size + s;
                    }
                }
                return this.size;
            }

            private Iter iter(int i) throws QueryException {
                Iter iter = this.iters[i];
                if (iter == null) {
                    this.iters[i] = iter = List.this.exprs[i].iter(qc);
                }
                return iter;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.exprs.length == 2) {
            return ValueBuilder.concat(this.exprs[0].value(qc), this.exprs[1].value(qc), qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Expr expr : this.exprs) {
            vb.add(expr.value(qc));
        }
        return vb.value();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new List(this.info, List.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof List && super.equals(obj);
    }

    @Override
    public boolean isVacuous() {
        for (Expr expr : this.exprs) {
            if (expr.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String description() {
        return "expression list";
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }
}

