/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pos;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class And
extends Logical {
    public And(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.optimize(cc, true, ex -> new Or(this.info, (Expr)ex));
    }

    @Override
    void simplify(CompileContext cc, ExprList list) {
        int es = this.exprs.length;
        for (int e = 0; e < es; ++e) {
            Expr tmp;
            Expr expr = this.exprs[e];
            if (expr instanceof ItrPos) {
                while (e + 1 < es && this.exprs[e + 1] instanceof ItrPos) {
                    expr = ((ItrPos)expr).intersect((ItrPos)this.exprs[e + 1], this.info);
                    ++e;
                }
            } else if (expr instanceof Pos) {
                while (e + 1 < es && this.exprs[e + 1] instanceof Pos && (tmp = ((Pos)expr).intersect((Pos)this.exprs[e + 1], this.info)) != null) {
                    expr = tmp;
                    ++e;
                }
            } else if (expr instanceof CmpR) {
                while (e + 1 < es && this.exprs[e + 1] instanceof CmpR && (tmp = ((CmpR)expr).intersect((CmpR)this.exprs[e + 1])) != null) {
                    expr = tmp;
                    ++e;
                }
            } else if (expr instanceof CmpSR) {
                while (e + 1 < es && this.exprs[e + 1] instanceof CmpSR && (tmp = ((CmpSR)expr).intersect((CmpSR)this.exprs[e + 1])) != null) {
                    expr = tmp;
                    ++e;
                }
            }
            if (!list.contains(expr) || expr.has(Flag.NDT)) {
                list.add(cc.replaceWith(this.exprs[e], expr));
                continue;
            }
            cc.info("remove % from %", this.exprs[e], this.description());
        }
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        if (qc.scoring) {
            double score = 0.0;
            for (Expr expr : this.exprs) {
                Item item = expr.ebv(qc, this.info);
                if (!item.bool(this.info)) {
                    return Bln.FALSE;
                }
                score += item.score();
            }
            return Bln.get(true, Scoring.avg(score, this.exprs.length));
        }
        for (Expr expr : this.exprs) {
            if (expr.ebv(qc, this.info).bool(this.info)) continue;
            return Bln.FALSE;
        }
        return Bln.TRUE;
    }

    @Override
    public And copy(CompileContext cc, IntObjMap<Var> vars) {
        return new And(this.info, And.copyAll((CompileContext)cc, vars, (Expr[])this.exprs));
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            if (ii.costs.results() == 0) {
                return true;
            }
            costs = IndexCosts.add(costs, ii.costs);
            list.add(ii.expr);
        }
        ii.costs = costs;
        ii.expr = new Intersect(this.info, (Expr[])list.finish());
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof And && super.equals(obj);
    }

    @Override
    public String toString() {
        return this.toString(" and ");
    }
}

