/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.ValuesBuilder;
import org.basex.index.value.MemValues;
import org.basex.util.Token;
import org.basex.util.Util;

public class MemValuesBuilder
extends ValuesBuilder {
    public MemValuesBuilder(Data data, IndexType type) {
        super(data, type);
    }

    @Override
    public MemValues build() throws IOException {
        Util.debug(this.detailedInfo(), new Object[0]);
        MemValues index = new MemValues(this.data, this.type);
        boolean updindex = this.data.meta.updindex;
        this.pre = 0;
        while (this.pre < this.size) {
            if ((this.pre & 0xFFF) == 0) {
                this.check();
            }
            if (this.indexEntry()) {
                if (this.tokenize) {
                    for (byte[] token : Token.distinctTokens(this.data.text(this.pre, this.text))) {
                        index.add(token, updindex ? this.data.id(this.pre) : this.pre);
                        ++this.count;
                    }
                } else if (this.data.textLen(this.pre, this.text) <= this.data.meta.maxlen) {
                    index.add(this.data.text(this.pre, this.text), updindex ? this.data.id(this.pre) : this.pre);
                    ++this.count;
                }
            }
            ++this.pre;
        }
        index.finish();
        this.finishIndex();
        return index;
    }
}

