/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.plot;

import java.util.Arrays;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.gui.view.plot.PlotAxis;
import org.basex.index.name.Names;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class PlotData {
    final Context context;
    final PlotAxis xAxis;
    final PlotAxis yAxis;
    int[] pres;
    byte[] item = Token.EMPTY;

    PlotData(Context ctx) {
        this.xAxis = new PlotAxis(this);
        this.yAxis = new PlotAxis(this);
        this.pres = new int[0];
        this.context = ctx;
    }

    TokenList getItems() {
        Data data = this.context.data();
        TokenList tl = new TokenList();
        for (byte[] k : data.paths.desc(Token.EMPTY, true, true)) {
            if (this.getCategories(k).size() <= 1) continue;
            tl.add(k);
        }
        return tl;
    }

    TokenList getCategories(byte[] it) {
        Data data = this.context.data();
        TokenList tl = new TokenList();
        for (byte[] k : data.paths.desc(it, true, false)) {
            Names names;
            Names names2 = names = Token.startsWith(k, 64) ? data.attrNames : data.elemNames;
            if (names.stats((int)names.id((byte[])Token.delete((byte[])k, (int)64))).type == 4) continue;
            tl.add(k);
        }
        return tl;
    }

    boolean setItem(String newItem) {
        if (newItem == null) {
            return false;
        }
        byte[] b = Token.token(newItem);
        if (Token.eq(b, this.item)) {
            return false;
        }
        this.item = b;
        this.refreshItems(this.context.current(), true);
        return true;
    }

    void refreshItems(DBNodes nodes, boolean sub) {
        int[] contextPres;
        Data data = this.context.data();
        IntList il = new IntList();
        int itmID = data.elemNames.id(this.item);
        if (!sub) {
            this.pres = nodes.pres();
            Arrays.sort(this.pres);
            return;
        }
        for (int p : contextPres = nodes.pres()) {
            if (p >= data.meta.size) break;
            int nl = p + data.size(p, 1);
            while (p < nl) {
                int kind = data.kind(p);
                if (kind == 1) {
                    if (data.nameId(p) == itmID) {
                        il.add(p);
                    }
                    p += data.attSize(p, 1);
                    continue;
                }
                ++p;
            }
        }
        this.pres = il.finish();
        Arrays.sort(this.pres);
    }

    int findPre(int pre) {
        return Arrays.binarySearch(this.pres, pre);
    }
}

